/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.registry;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.ControlMessageFactory;
import rescuecore2.registry.EntityFactory;
import rescuecore2.registry.MessageFactory;
import rescuecore2.registry.PropertyFactory;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;

public final class Registry {
    public static final Registry SYSTEM_REGISTRY = new Registry("System", null);
    private static final ThreadLocal<Registry> CURRENT_REGISTRY = new InheritableThreadLocal<Registry>(){

        @Override
        public Registry initialValue() {
            return SYSTEM_REGISTRY;
        }
    };
    private final Map<String, EntityFactory> entityFactories;
    private final Map<String, PropertyFactory> propertyFactories;
    private final Map<String, MessageFactory> messageFactories;
    private final Registry parent;
    private final String name;

    public Registry() {
        this(null, SYSTEM_REGISTRY);
    }

    public Registry(String name) {
        this(name, SYSTEM_REGISTRY);
    }

    public Registry(Registry parent) {
        this(null, parent);
    }

    public Registry(String name, Registry parent) {
        this.name = name;
        this.parent = parent;
        this.entityFactories = new HashMap<String, EntityFactory>();
        this.propertyFactories = new HashMap<String, PropertyFactory>();
        this.messageFactories = new HashMap<String, MessageFactory>();
    }

    public static Registry getCurrentRegistry() {
        return CURRENT_REGISTRY.get();
    }

    public static void setCurrentRegistry(Registry r) {
        CURRENT_REGISTRY.set(r);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    public void registerEntityFactory(EntityFactory factory) {
        for (String urn : factory.getKnownEntityURNs()) {
            this.registerEntityFactory(urn, factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEntityFactory(String urn, EntityFactory factory) {
        Map<String, EntityFactory> map = this.entityFactories;
        synchronized (map) {
            EntityFactory old = this.entityFactories.get(urn);
            if (old != null && old != factory) {
                Logger.warn(this.getName() + ": entity " + urn + " is being clobbered by " + factory + ". Old factory: " + old);
            }
            this.entityFactories.put(urn, factory);
        }
    }

    public void registerPropertyFactory(PropertyFactory factory) {
        for (String urn : factory.getKnownPropertyURNs()) {
            this.registerPropertyFactory(urn, factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPropertyFactory(String urn, PropertyFactory factory) {
        Map<String, PropertyFactory> map = this.propertyFactories;
        synchronized (map) {
            PropertyFactory old = this.propertyFactories.get(urn);
            if (old != null && old != factory) {
                Logger.warn(this.getName() + ": property " + urn + " is being clobbered by " + factory + ". Old factory: " + old);
            }
            this.propertyFactories.put(urn, factory);
        }
    }

    public void registerMessageFactory(MessageFactory factory) {
        for (String urn : factory.getKnownMessageURNs()) {
            this.registerMessageFactory(urn, factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageFactory(String urn, MessageFactory factory) {
        Map<String, MessageFactory> map = this.messageFactories;
        synchronized (map) {
            MessageFactory old = this.messageFactories.get(urn);
            if (old != null && old != factory) {
                Logger.warn(this.getName() + ": message " + urn + " is being clobbered by " + factory + ". Old factory: " + old);
            }
            this.messageFactories.put(urn, factory);
        }
    }

    public Entity createEntity(String urn, EntityID id) {
        EntityFactory factory = this.getEntityFactory(urn);
        if (factory == null) {
            Logger.warn(this.getName() + ": Entity " + urn + " not recognised.");
            return null;
        }
        return factory.makeEntity(urn, id);
    }

    public Property createProperty(String urn) {
        PropertyFactory factory = this.getPropertyFactory(urn);
        if (factory == null) {
            Logger.warn(this.getName() + ": Property " + urn + " not recognised.");
            return null;
        }
        return factory.makeProperty(urn);
    }

    public Message createMessage(String urn, InputStream data) throws IOException {
        MessageFactory factory = this.getMessageFactory(urn);
        if (factory == null) {
            Logger.warn(this.getName() + ": Message " + urn + " not recognised.");
            return null;
        }
        return factory.makeMessage(urn, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityFactory getEntityFactory(String urn) {
        EntityFactory result = null;
        Map<String, EntityFactory> map = this.entityFactories;
        synchronized (map) {
            result = this.entityFactories.get(urn);
        }
        if (result == null && this.parent != null) {
            result = this.parent.getEntityFactory(urn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyFactory getPropertyFactory(String urn) {
        PropertyFactory result = null;
        Map<String, PropertyFactory> map = this.propertyFactories;
        synchronized (map) {
            result = this.propertyFactories.get(urn);
        }
        if (result == null && this.parent != null) {
            result = this.parent.getPropertyFactory(urn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageFactory getMessageFactory(String urn) {
        MessageFactory result = null;
        Map<String, MessageFactory> map = this.messageFactories;
        synchronized (map) {
            result = this.messageFactories.get(urn);
        }
        if (result == null && this.parent != null) {
            result = this.parent.getMessageFactory(urn);
        }
        return result;
    }

    static {
        SYSTEM_REGISTRY.registerMessageFactory(ControlMessageFactory.INSTANCE);
    }
}

