/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel;

import rescuecore2.worldmodel.AbstractEntity;
import rescuecore2.worldmodel.Property;

public abstract class AbstractProperty
implements Property {
    private boolean defined;
    private final String urn;
    private AbstractEntity entity;

    protected AbstractProperty(String urn) {
        this(urn, false);
    }

    protected AbstractProperty(Enum<?> urn) {
        this(urn.toString(), false);
    }

    protected AbstractProperty(String urn, boolean defined) {
        this.urn = urn;
        this.defined = defined;
        this.entity = null;
    }

    protected AbstractProperty(Enum<?> urn, boolean defined) {
        this(urn.toString(), defined);
    }

    protected AbstractProperty(AbstractProperty other) {
        this(other.getURN(), other.isDefined());
    }

    protected void setDefined() {
        this.defined = true;
    }

    protected void setEntity(AbstractEntity e) {
        this.entity = e;
    }

    @Override
    public boolean isDefined() {
        return this.defined;
    }

    @Override
    public void undefine() {
        Object old = this.getValue();
        this.defined = false;
        this.fireChange(old, null);
    }

    @Override
    public String getURN() {
        return this.urn;
    }

    protected void fireChange(Object oldValue, Object newValue) {
        if (this.entity != null) {
            this.entity.firePropertyChanged(this, oldValue, newValue);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getURN());
        if (this.isDefined()) {
            result.append(" = ");
            result.append(this.getValue());
        } else {
            result.append(" (undefined)");
        }
        return result.toString();
    }
}

