/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import rescuecore2.registry.Registry;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.WorldModel;
import rescuecore2.worldmodel.WorldModelListener;

public abstract class AbstractWorldModel<T extends Entity>
implements WorldModel<T> {
    private Set<WorldModelListener<? super T>> listeners = new HashSet<WorldModelListener<? super T>>();
    private Collection<Class<? extends T>> allowedClasses = new HashSet<Class<? extends T>>();

    protected AbstractWorldModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addWorldModelListener(WorldModelListener<? super T> l) {
        Set<WorldModelListener<? super T>> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeWorldModelListener(WorldModelListener<? super T> l) {
        Set<WorldModelListener<? super T>> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    @Override
    public final void addEntity(Entity e) {
        if (!this.isAllowed(e)) {
            throw new IllegalArgumentException(this + " does not accept entities of type " + e.getClass().getName());
        }
        this.addEntityImpl(e);
    }

    @Override
    public final void addEntities(Collection<? extends Entity> e) {
        for (Entity entity : e) {
            this.addEntity(entity);
        }
    }

    @Override
    public final void removeEntity(T e) {
        this.removeEntity((T)e.getID());
    }

    protected abstract void addEntityImpl(T var1);

    @Override
    public void merge(Collection<? extends Entity> toMerge) {
        for (Entity entity : toMerge) {
            Object existing = this.getEntity(entity.getID());
            if (existing == null) {
                this.addEntity(entity);
                continue;
            }
            Set<Property> props = existing.getProperties();
            for (Property prop : props) {
                Property other = entity.getProperty(prop.getURN());
                if (!other.isDefined()) continue;
                prop.takeValue(other);
            }
        }
    }

    @Override
    public void merge(ChangeSet changeSet) {
        for (EntityID e : changeSet.getChangedEntities()) {
            Object existingEntity = this.getEntity(e);
            boolean add = false;
            if (existingEntity == null) {
                existingEntity = Registry.getCurrentRegistry().createEntity(changeSet.getEntityURN(e), e);
                if (existingEntity == null) continue;
                add = true;
            }
            for (Property p : changeSet.getChangedProperties(e)) {
                Property existingProperty = existingEntity.getProperty(p.getURN());
                existingProperty.takeValue(p);
            }
            if (!add) continue;
            this.addEntity((Entity)existingEntity);
        }
        for (EntityID next : changeSet.getDeletedEntities()) {
            this.removeEntity((T)next);
        }
    }

    protected final void fireEntityAdded(T e) {
        for (WorldModelListener<T> l : this.getListeners()) {
            l.entityAdded(this, e);
        }
    }

    protected final void fireEntityRemoved(T e) {
        for (WorldModelListener<T> l : this.getListeners()) {
            l.entityRemoved(this, e);
        }
    }

    protected boolean isAllowed(Entity e) {
        for (Class<T> next : this.allowedClasses) {
            if (!next.isAssignableFrom(e.getClass())) continue;
            return true;
        }
        return false;
    }

    protected void registerAllowedClass(Class<? extends T> clazz) {
        this.allowedClasses.add(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<WorldModelListener<? super T>> getListeners() {
        Set<WorldModelListener<? super T>> set = this.listeners;
        synchronized (set) {
            return new HashSet<WorldModelListener<? super T>>(this.listeners);
        }
    }
}

