/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.AbstractTool;
import gis2.scenario.ScenarioEditor;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.gml.GMLSpace;
import maps.gml.view.BuildingDecorator;
import maps.gml.view.FilledShapeDecorator;
import maps.gml.view.RoadDecorator;
import maps.gml.view.SpaceDecorator;

public abstract class ShapeTool
extends AbstractTool {
    private static final Color HIGHLIGHT_COLOUR = new Color(0, 0, 255, 128);
    private Listener listener = new Listener();
    private FilledShapeDecorator highlight = new FilledShapeDecorator(HIGHLIGHT_COLOUR, HIGHLIGHT_COLOUR, HIGHLIGHT_COLOUR);
    private GMLShape highlightShape;

    public ShapeTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener((MouseListener)this.listener);
        this.editor.getViewer().addMouseMotionListener((MouseMotionListener)this.listener);
        this.highlightShape = null;
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener((MouseListener)this.listener);
        this.editor.getViewer().removeMouseMotionListener((MouseMotionListener)this.listener);
        this.editor.getViewer().clearAllBuildingDecorators();
        this.editor.getViewer().clearAllRoadDecorators();
        this.editor.getViewer().clearAllSpaceDecorators();
        this.editor.getViewer().repaint();
    }

    protected abstract void processClick(GMLShape var1);

    protected abstract boolean shouldHighlight(GMLShape var1);

    private void highlight(GMLShape newShape) {
        if (!this.shouldHighlight(newShape)) {
            return;
        }
        if (this.highlightShape == newShape) {
            return;
        }
        if (this.highlightShape != null) {
            if (this.highlightShape instanceof GMLBuilding) {
                this.editor.getViewer().clearBuildingDecorator(new GMLBuilding[]{(GMLBuilding)this.highlightShape});
            }
            if (this.highlightShape instanceof GMLRoad) {
                this.editor.getViewer().clearRoadDecorator(new GMLRoad[]{(GMLRoad)this.highlightShape});
            }
            if (this.highlightShape instanceof GMLSpace) {
                this.editor.getViewer().clearSpaceDecorator(new GMLSpace[]{(GMLSpace)this.highlightShape});
            }
        }
        this.highlightShape = newShape;
        if (this.highlightShape != null) {
            if (this.highlightShape instanceof GMLBuilding) {
                this.editor.getViewer().setBuildingDecorator((BuildingDecorator)this.highlight, new GMLBuilding[]{(GMLBuilding)this.highlightShape});
            }
            if (this.highlightShape instanceof GMLRoad) {
                this.editor.getViewer().setRoadDecorator((RoadDecorator)this.highlight, new GMLRoad[]{(GMLRoad)this.highlightShape});
            }
            if (this.highlightShape instanceof GMLSpace) {
                this.editor.getViewer().setSpaceDecorator((SpaceDecorator)this.highlight, new GMLSpace[]{(GMLSpace)this.highlightShape});
            }
        }
        this.editor.getViewer().repaint();
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ShapeTool.this.highlightShape != null && e.getButton() == 1) {
                ShapeTool.this.processClick(ShapeTool.this.highlightShape);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = ShapeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
            ShapeTool.this.highlight(ShapeTool.this.editor.getMap().findShapeUnder(c.getX(), c.getY()));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = ShapeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

