import javax.swing.*;
import org.gui.*;
import java.io.*;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import javax.swing.event.*;
import javax.swing.text.html.*;

public class Main___GUI{

	public static void main(String[] args) throws Exception {

		final JTextPane tp = new JTextPane();
		final JTextField tf = new JTextField();

		GUITool.tryToSetSystemLookAndFeel();
		JFrame frame_tmp = null;
		
		JButton button = new JButton("test");
		button.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				System.out.println("test");
			}
		});
		JPanel contentpane = new JPanel(new BorderLayout());
		contentpane.add(button, BorderLayout.NORTH);
		contentpane.add(new JScrollPane(tp), BorderLayout.CENTER);
		tp.setEditable(false);
		tp.addHyperlinkListener(new HyperlinkListener(){
			public void hyperlinkUpdate(HyperlinkEvent e) {
				if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
					JEditorPane pane = (JEditorPane) e.getSource();
					if (e instanceof HTMLFrameHyperlinkEvent) {
						HTMLFrameHyperlinkEvent  evt = (HTMLFrameHyperlinkEvent)e;
						HTMLDocument doc = (HTMLDocument)pane.getDocument();
						doc.processHTMLFrameHyperlinkEvent(evt);
					} else {
						try {
							pane.setPage(e.getURL());
							tf.setText(e.getURL().toString());
						} catch (Throwable t) {
							t.printStackTrace();
						}
					}
				}
			}
		});
		tf.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				try{
					tp.setPage(((JTextField)e.getSource()).getText());
				}catch(Exception exc){
					exc.printStackTrace();
				}
			}
		});
		contentpane.add(tf, BorderLayout.SOUTH);
		
		frame_tmp = new JFrame();
		frame_tmp.setContentPane(contentpane);
		frame_tmp.pack();
		final String config_file_name = ".GUITool_frame_state.xml";

		try{
			XMLDecoder decoder = new XMLDecoder(new FileInputStream(config_file_name));
			Rectangle bounds = (Rectangle)decoder.readObject();
			frame_tmp.setBounds(bounds);
			String url_text = (String)decoder.readObject();
			tf.setText(url_text);
			tp.setPage(new URL(url_text));
		}catch(Exception e){
			e.printStackTrace();
		}
		
		frame_tmp.setVisible(true);
		final JFrame frame = frame_tmp;
		frame.addWindowListener(new WindowAdapter(){
			@Override
			public void windowClosing(WindowEvent e) {
				try{
					XMLEncoder encoder = new XMLEncoder(new FileOutputStream(config_file_name));
					encoder.writeObject(frame.getBounds());
					encoder.writeObject(tf.getText());
					encoder.flush();
					encoder.close();
				}catch(Exception exc){
					exc.printStackTrace();
				}
				System.exit(0);
			}
		});

		
		
		File[] file = GUITool.openFiles(null, "open");
		for(int i=0;i<file.length;i++)
			JOptionPane.showMessageDialog(null, file[i].getAbsolutePath());
	}
}
