package org.util.html.demo;

import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import org.util.html.objects.*;
import org.util.html.render.*;
import org.util.html.factory.*;
import org.util.log.*;


public class Demo1 {
    
    private JFrame frame_;
    private JComponent main_content_;
    private LogListener log_listener_;

    private HTMLDocument document_;
    private HTMLDocumentRenderer renderer_;
    private HTMLDocumentFactory factory_;
    private JButton back_, update_, go_;
    private JTextField text_;
    private int scroll_bar_width_ = 15;
    
    public static void main(String[] args) throws Exception {
	final Demo1 demo = new Demo1();
	SwingUtilities.invokeAndWait(new Runnable(){public void run(){
	    demo.createAndShowGUI1();
	}});
	SwingUtilities.invokeAndWait(new Runnable(){public void run(){
	    demo.createAndShowGUI2();
	}});
	Thread init_process = new Thread(new Runnable(){
		public void run(){
		    demo.start();
		}
	    }, "demo process");
	init_process.start();
	init_process.join();
	SwingUtilities.invokeAndWait(new Runnable(){public void run(){
	    demo.createAndShowGUI3();
	}});
    }
    private void createAndShowGUI1() {
	JFrame frame = new JFrame("Demo1");
	frame.setSize(500, 500);
	frame.setLocationRelativeTo(null);
	frame.setVisible(true);
	frame_ = frame;
    }
    private void createAndShowGUI2() {
	back_ = new JButton("<");
	update_ = new JButton("o");
	text_ = new JTextField();
	go_ = new JButton(">");

	JPanel toolpane = new JPanel();
	toolpane.setPreferredSize(new Dimension(500, 24));
	toolpane.setLayout(new BoxLayout(toolpane, BoxLayout.X_AXIS));
	toolpane.add(back_);
	toolpane.add(update_);
	toolpane.add(text_);
	toolpane.add(go_);

	JPanel contentpane = new JPanel(new BorderLayout());
	contentpane.add(toolpane, BorderLayout.NORTH);
	
	frame_.setContentPane(contentpane);
	contentpane.revalidate();
    }
    private void createAndShowGUI3() {

	text_.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent e) {
		    openInOtherThread(text_.getText());
		}
	    });

	main_content_ = renderer_.getPanel();

	MouseManager mouse_manager = new MouseManager();
	main_content_.addMouseListener(mouse_manager);
	main_content_.addMouseMotionListener(mouse_manager);
	//main_content_.addMouseWheelListener(mouse_manager);
	
	main_content_.addComponentListener(new ComponentAdapter(){
		public void componentResized(ComponentEvent e) {
		    Component c = e.getComponent();
		    renderer_.resized(c.getWidth(), c.getHeight());
		}
	    });
	main_content_.setFocusable(true);
	
	JScrollPane sp = new JScrollPane(main_content_);
	sp.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
	sp.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
	renderer_.setScrollPane(sp);
	
	frame_.getContentPane().add(sp);

	frame_.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	Image icon = org.util.resource.ResourceManager.getImage("./data/icon/frame_icon.png", 30, 30);
	frame_.setIconImage(icon);
    }

    private void start() {
	HTMLDocument document = new HTMLDocument();
	HTMLDocumentRenderer renderer = new HTMLDocumentRenderer(document);
	renderer.addHTMLDocumentRendererListener(new HTMLDocumentRendererListener(){
		public void repaint() {
		    if(main_content_!=null)
			main_content_.repaint();
		}
	    });
	document_ = document;
	renderer_ = renderer;
	factory_ = new HTMLDocumentFactory();
	factory_.setLogListener(getLogListener());
	try{
	    openSamplePage();
	}catch(Exception e) {
	    alertError(e);
	}
    }

    private void openSamplePage() throws Exception {
	open("http://sakura.meijo-u.ac.jp");
    }
    
    private void openInOtherThread(final String url_text) {
	new Thread(new Runnable(){public void run(){
	    try{
		open(url_text);
	    }catch(Exception e) {
		alertError(e);
	    }
	}}, "open url").start();
    }

    private void open(String url_text) throws Exception {
	URL url = new URL(url_text);
	frame_.setTitle(url.toString());
	factory_.createDocument(url, document_);
    }

    private class MouseManager implements MouseListener, MouseMotionListener, MouseWheelListener {
	private int last_x;
	private int last_y;
	private int pressed_x;
	private int pressed_y;

	public void mousePressed(MouseEvent e) {
	    main_content_.requestFocus();
	    pressed_x = e.getX();
	    pressed_y = e.getY();
	}
	public void mouseReleased(MouseEvent e) {
	    
	}
	public void mouseClicked(MouseEvent e) {
	    
	}
	public void mouseEntered(MouseEvent e) {

	}
	public void mouseExited(MouseEvent e) {

	}
	public void mouseMoved(MouseEvent e) {
	    int x = e.getX();
	    int y = e.getY();
	    
	    last_x = x;
	    last_y = y;
	}
	public void mouseDragged(MouseEvent e) {
	    int x = e.getX();
	    int y = e.getY();

	    last_x = x;
	    last_y = y;
	}
	public void mouseWheelMoved(MouseWheelEvent e) {
	    //renderer_.moveView(0, -e.getWheelRotation()*20);
	}
    }

    

    private LogListener getLogListener(){
	if(log_listener_==null){
	    log_listener_ = new GUIAlert(main_content_);
	}
	return log_listener_;
    }

    public void alert(Object message) {
	getLogListener().alert(message);
    }
    public void alertError(Object message) {
	getLogListener().alertError(message);
    }
    public void log(Object message) {
	getLogListener().log(message);
    }

}
