package org.util.html.objects;

import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class HTMLImg extends HTMLObject {

    private HTMLImg this_ = this;
    private JComponent component_;
    private URL url_;
    private BufferedImage image_;
    private Dimension preferred_size_;

    public HTMLImg(HTMLDocument root) {
	super(root);
	try{
	SwingUtilities.invokeAndWait(new Runnable(){public void run(){
	component_ = new JComponent() {
		public void paint(Graphics g) {
		    int w = getWidth();
		    int h = getHeight();
		    if(image_ == null) {
			g.setColor(Color.black);
			g.setFont(new Font("monospace", Font.PLAIN, 8));
			URL url = getURL();
			if(url!=null) {
			    String url_text = url.toString();
			    int d = 15;
			    for(int i=0; i<url_text.length()/d; i++)
				g.drawString(url_text.substring(i*d, Math.min((i+1)*d, url_text.length())), 3 ,8*i+10);
			}
			g.setColor(Color.red);
			g.drawRect(0,0,w-1,h-1);
		    } else {
			g.drawImage(image_, 0, 0, w, h, component_);
		    }
		}
	    };
	component_.setPreferredSize(new Dimension(100, 100));
	}});
	}catch(Exception exc){}
    }
    public void setURL(URL url) {
	url_ = url;
	new Thread(new Runnable(){
		public void run(){
		    try{
			image_ = javax.imageio.ImageIO.read(url_);
			if(preferred_size_ != null) {
			    int hint = Image.SCALE_FAST;
			    image_ = (BufferedImage)image_.getScaledInstance((int)preferred_size_.getWidth(), (int)preferred_size_.getHeight(), hint);
			}
			component_.setPreferredSize(new Dimension(image_.getWidth(), image_.getHeight()));
			component_.revalidate();
			getRoot().changed(this_);
		    }catch(Exception exc){
			exc.printStackTrace();
		    }
		    
		}
	    }).start();
    }

    public void setPreferredSize(Dimension size) {
	preferred_size_ = size;
    }
    public URL getURL() {
	return url_;
    }
    public JComponent getPanel() {
	return component_;
    }
}
