/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml;

import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.util.xml.element.Element;
import org.util.xml.element.TagElement;
import org.util.xml.element.TextElement;
import org.util.xml.parse.policy.HTMLParserPolicy;
import org.util.xml.parse.ElementParser;

/**
 *
 * @author masaru
 */
public class Main2 {
    
    JPanel panel;
    
    public static void main(String[] args) {
        new Main2();
    }
    
    public Main2() {
        JTextField textfield = new JTextField("http://www.google.com/");
        textfield.addActionListener(new ActionListener(){
            public void actionPerformed(final ActionEvent e) {
                new Thread(new Runnable(){public void run(){
                    openURL(((JTextField)e.getSource()).getText());
                }}).start();
            }
        });
        panel = new JPanel(new FlowLayout());

        JPanel contentpane = new JPanel(new BorderLayout());
        contentpane.add(textfield,BorderLayout.NORTH);
        contentpane.add(panel,BorderLayout.CENTER);
        contentpane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setContentPane(contentpane);
        frame.setSize(200,200);
        frame.setLocation(100,100);
        frame.setVisible(true);
    }
    public void openURL(String urltext) {
        try{
            URL url = new URL(urltext);
            ElementParser parser = new ElementParser(url.openStream());
            parser.setPolicy(new HTMLParserPolicy(){

                @Override
                public Element allowElement(Element element) {
                    super.allowElement(element);
                    
                    if(element.isTextElement()) {

                        TextElement text = (TextElement)element;
                        if(true) {
                            String doc = text.getValue();
//JOptionPane.showMessageDialog(null, doc);
                            int num = doc.indexOf("embedUrl");
                            if(num != -1) {
                                int start = doc.indexOf("\'", num) + 1;
                                int end = doc.indexOf("\'", start);
                                String value = doc.substring(start, end);
//JOptionPane.showMessageDialog(null, value);
                                final String url = value;
                                String comment = "";
                                JButton button = new JButton(new AbstractAction(url){
                                    public void actionPerformed(ActionEvent arg0) {
                                        try{
                                            Desktop.getDesktop().browse(new URI(url));
                                        }catch(Exception e){
                                            JOptionPane.showMessageDialog(null, "Error:"+e.getMessage()+"\n"+url);
                                        }
                                    }
                                });
                                button.setToolTipText("<html><body>"+comment+"</body></html>");
                                panel.add(button);
                                panel.doLayout();
                            }
                        }
                    }
                        
                    return null;
                }
                
            });
            parser.parse();
        } catch(Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e);
        }
    }
}
