/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.element;

/**
 *
 * @author masaru
 */
public class TextElement extends Element {

    private String value_;
    private boolean is_comment_;
    private boolean is_cdata_;
    private boolean is_tag_;

    @Override public boolean isTagElement() { return false; }
    @Override public boolean isTextElement() { return true; }
    
    public TextElement(String value) {
        setValue(value);
    }
    
    public boolean isCommentTag() {
        return is_comment_;
    }
    public void setCommenTag(boolean is_comment) {
        is_comment_ = is_comment;
        is_cdata_ = false;
        if(is_comment) is_tag_ = true;
    }
    
    public boolean isCDATATag() {
        return is_cdata_;
    }
    public void setCDATATag(boolean is_cdata) {
        is_cdata_ = is_cdata;
        is_comment_ = !is_cdata;
        if(is_cdata) is_tag_ = true;
    }
    
    public boolean isTag() {
        return is_tag_;
    }
    public void setTag(boolean is_tag) {
        is_tag_ = is_tag;
        if(!is_tag) {
            is_cdata_ = false;
            is_comment_ = false;
        }
    }
    
    public void setValue(String value) {
        value_ = value;
    }
    public String getValue() {
        return value_;
    }
    
    public String toString() {
        if(is_cdata_)
            return "<![CDATA["+getValue()+"]]>\n";
        else if(is_comment_)
            return "<!--"+getValue()+"-->\n";
        else if(is_tag_)
            return "<!"+getValue()+">\n";
        else
            return getValue();
    }
}
