/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse.policy;

import org.util.xml.element.Element;

/**
 *
 * @author masaru
 */
public interface ParserPolicy {

    /**
     * Throw exception if document has error.
     * In case this method returns false, if there are errors, skip some texts and continue parsing.
     */
    public boolean throwExceptionIfDocumentHasError();
    
    /**
     * if true, check open tag key and close tag key. 
     */
    public boolean checkEndTag();
    
    /**
     * if encoding cannot be detected by first line of document, this method will be called.
     * while returned null, this method will be called every time that tag detected.
	 */
    public String selectEncoding(String last_tag_key);
    
    /**
     * Basicly, all the tag must open and close.
     * But if this method return true, opentag will be considerd to empty tag. So end tag will disregarded. 
     */
    public boolean forceEmptyTag(String key);
    
    //public boolean allowTagSize();
    
    /**
     * return handler that handle this element
     */
    public ParserPolicy getInnerPolicy(Element element);
    
    /**
     * called when element is detected.
     */
    public Element allowElement(Element element);
    
    public boolean finished();
}
