package org.util.xml.renderer.html;

import org.util.xml.parse.policy.*;
import org.util.xml.parse.*;
import org.util.xml.element.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.awt.font.*;
import java.awt.image.*;

public class HTMLText extends HTMLObject {

	private String html_text_;

	public HTMLText(String html_text) {
		html_text_ = html_text;
	}
	public void mousePressed(MouseEvent e) {
		setBackground(Color.blue);
	}
	public void mouseReleased(MouseEvent e) {
		setBackground(Color.red);
	}
	public void mouseEntered(MouseEvent e) {
		setBackground(Color.green);
	}
	public void mouseExited(MouseEvent e) {
		setBackground(Color.white);
	}
	public boolean hit(double x, double y) {
		if(x-x_<0 || x-x_>width_) return false;
		if(y-y_<0 || y-y_>height_) return false;
		return true;
	}
	public void paint(Graphics g) {
		debug("draw start");
		g.setColor(background_);
		g.fillRect((int)x_,(int)y_,(int)width_,(int)height_);
		g.setColor(foreground_);
		
		Font font = new Font("Arial", Font.PLAIN, 10);
		FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
		String text = html_text_;
		String[] lines = text.split("\n");
		double now_y = margin_up_;
		double max_width = 0;
		
		TextLayout text_layout = null;
		for(int i=0;i<lines.length;i++) {
			if(lines[i].length()==0) continue;
			text_layout = new TextLayout(lines[i], font, frc);
			float d = text_layout.getAscent();
			text_layout.draw((Graphics2D)g, (float)(x_+margin_left_), (float)(y_+d+now_y));
			Rectangle2D rect = text_layout.getBounds();
			now_y += rect.getHeight();
			max_width = Math.max(max_width, rect.getWidth());
		}
		if(!init_) {
			if(text_layout != null)
				now_y += text_layout.getDescent();
			setPreferredSize(margin_left_+max_width+margin_right_, now_y+margin_bottom_);
			init_ = true;
		}
		debug("draw end");
	}

	public Element allowElement(Element element) {
		if(element.isTagElement()) {
			TagElement tag = (TagElement)element;
			System.out.println("tag["+tag+"]");
		} else {
			TextElement text_element = (TextElement)element;
//			System.out.println("text["+element+"]");
			html_text = text_element.getValue();
		}
		return element;
	}

}
