/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import javax.swing.JFileChooser;
import org.util.xml.element.Element;
import org.util.xml.parse.ElementParser;

/**
 *
 * @author masaru
 */
public class XMLComparator {
    
    public static boolean isSameAsXML(File a, File b) throws Exception {
        ElementParser ap = new ElementParser(new FileInputStream(a));
        ap.parse();
        ElementParser bp = new ElementParser(new FileInputStream(b));
        bp.parse();
        return isSameAsXML(ap.getResult(), bp.getResult());
    }

    public static boolean isSameAsXML(String a, String b) throws Exception {
        ElementParser ap = new ElementParser(new StringReader(a));
        ap.parse();
        ElementParser bp = new ElementParser(new StringReader(b));
        bp.parse();
        return isSameAsXML(ap.getResult(), bp.getResult());
    }
    
    public static boolean isSameAsXML(Element[] a, Element[] b) {
        if(a.length!=b.length) return false;
        for(int i=0;i<a.length;i++)
            if(!isSameAsXML(a[i], b[i])) return false;
        return true;
    }
    
    public static boolean isSameAsXML(Element a, Element b) {
        String as = a.toString();
        String bs = b.toString();
        return as.equals(bs);
    }
    
    public static void main(String[] args) throws Exception {
        JFileChooser fc = new JFileChooser();
        if(fc.showOpenDialog(null) != JFileChooser.APPROVE_OPTION)
            throw new Exception("canceled to select file!");
        File file1 = fc.getSelectedFile();
        
        if(fc.showOpenDialog(null) != JFileChooser.APPROVE_OPTION)
            throw new Exception("canceled to select file!");
        File file2 = fc.getSelectedFile();
        System.out.println("file1: "+file1.getAbsolutePath());
        System.out.println("file2: "+file2.getAbsolutePath());
        System.out.println("file1 == file2: "+isSameAsXML(file1, file2));
    }
}
