//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CSChar.cs
 * @brief		Char g t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2013-2014 Takazumi Shirayanagi\n
 * This software is released under the MIT License,
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// using
using System;

namespace Common
{
	static class CSCharctors
	{
		#region IsControls
		/// <summary>
		/// 䕶݂̂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsControls(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsControl(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsDigits
		/// <summary>
		/// 10i\L݂̐̂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsDigits(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsDigit(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsLetter
		/// <summary>
		/// At@xbĝ݂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsLetters(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsLetter(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsLetterOrDigits
		/// <summary>
		/// At@xbg or 10î݂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsLetterOrDigits(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsLetterOrDigit(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsLowers
		/// <summary>
		/// At@xbĝ݂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsLowers(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsLower(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsNumbers
		/// <summary>
		/// ݂̂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsNumbers(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsNumber(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsPunctuations
		/// <summary>
		/// ؂蕶݂̂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsPunctuations(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsPunctuation(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsSeparators
		/// <summary>
		/// ؂蕶݂̂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsSeparators(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsSeparator(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsSymbols
		/// <summary>
		/// L݂̂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsSymbols(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsSymbol(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsUppers
		/// <summary>
		/// 啶At@xbĝ݂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsUppers(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsUpper(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region IsWhiteSpaces
		/// <summary>
		/// 󔒂݂̂ō\ꂽ񂩂ǂ
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		public static bool IsWhiteSpaces(string str)
		{
			for (int i = 0; i < str.Length; ++i)
			{
				if (!Char.IsWhiteSpace(str[i])) return false;
			}
			return true;
		}
		#endregion

		#region StripAlphaNumber
		public static string StripAlphaNumber(string buf)
		{
			string str = "";
			foreach (char ch in buf)
			{
				const string filter = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
				// { Letter  true ɂȂBBB
				//if (Char.IsLetterOrDigit(ch) )
				if( filter.IndexOf(ch) >= 0 )
				{
					str += ch;
				}
			}
			return str;
		}
		#endregion

	};
}	// end of namespace Common

