﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CSConsole.cs
 * @brief		Console ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2013-2014 Takazumi Shirayanagi\n
 * This software is released under the MIT License,
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// using
using System;
using System.Runtime.InteropServices;

namespace Common
{

	/// <summary>
	/// コンソール拡張クラス
	/// </summary>
	public class CSConsole
    {
        #region フィールド
        private static int m_Indent = 0;	//!< インデント値
        #endregion

        #region ReadLine
        public static string ReadLine()
		{
			Console.CursorLeft = m_Indent;
			return Console.ReadLine();
		}
		#endregion

		#region Write
		public static void Write(string msg)
		{
			_Write(msg);
		}
		public static void Write(string format, params object[] arg)
		{
			string str = String.Format(format, arg);
			_Write(str);
		}
		private static void _Write(string str)
		{
			if (str == null || str.Length == 0) return;

			string[] lines = str.Split(new char[] { '\n' });
			bool nl = false;
			try
			{
				foreach (string line in lines)
				{
					if (nl)
					{
						Console.WriteLine();
					}
					else
					{
						nl = true;
					}
					if (Console.CursorLeft == 0)
						Console.CursorLeft = m_Indent;
					Console.Write(line);
				}
			}
			catch
			{
			}
		}
		#endregion

		#region WriteLine
		public static void WriteLine()
		{
			Console.WriteLine();
		}
		public static void WriteLine(string msg)
		{
			_WriteLine(msg);
		}
		public static void WriteLine(string format, params object[] arg)
		{
			string str = String.Format(format, arg);
			_WriteLine(str);
		}
		private static void _WriteLine(string str)
		{
			if (str == null || str.Length == 0)
			{
				Console.WriteLine();
				return;
			}

			string[] lines = str.Split(new char[] { '\n' });
			try
			{
				foreach (string line in lines)
				{
					if (Console.CursorLeft == 0)
						Console.CursorLeft = m_Indent;
					Console.WriteLine(line);
				}
			}
			catch
			{
			}
		}
		#endregion

		#region WaitPressAnyKey
		public static void WaitPressAnyKey()
		{
			Console.WriteLine("prease press any key.");
			Console.ReadKey();
			Console.WriteLine("");
		}
		#endregion

		#region Indent
		public static int Indent
		{
			get { return m_Indent; }
			set { m_Indent = value; }
		}
		#endregion

		#region Cursor
		public static int CursorLeft
		{
			get { return Console.CursorLeft; }
			set { Console.CursorLeft = value; }
		}
		public static int CursorTop
		{
			get { return Console.CursorTop; }
			set { Console.CursorTop = value; }
		}
		#endregion

        #region AllocConsole
        [DllImport("kernel32.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern bool AllocConsole();
        #endregion
    }

}	// end of namespace Common

