// -*-c++-*-

/*!
  \file angle_deg.cpp
  \brief Degree wrapper class Source File.
*/

/*
 *Copyright:

 Copyright (C) 2004 Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "angle_deg.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

namespace rcsc {

const double AngleDeg::EPSILON = 0.01;

const double AngleDeg::DEG2RAD = M_PI / 180.0;
const double AngleDeg::RAD2DEG = 180.0 / M_PI;

/*-------------------------------------------------------------------*/
/*!
  \brief check if this angle is within [left, right].
  \param left left angle
  \param right right angle
  \return true if this is within [left, right]. else false
 */
bool
AngleDeg::isWithin( const AngleDeg & left, const AngleDeg & right ) const
{
    // left to right arc angle is less than 180 degree.
    if ( left.isLeftEqualOf( right ) )
    {
        if ( left.isLeftEqualOf( *this ) && this->isLeftEqualOf( right ) )
        {
            return true;
        }
    }
    // arc angle is more than 180 degree.
    else
    {
        // check out reverse side
        //if ( *this <= right || left <= *this )
        // == !(right < *this && *this < left)
        if ( this->isLeftEqualOf( right ) || left.isLeftEqualOf( *this ) )
        {
            return true;
        }
    }
    return false;
}

/*-------------------------------------------------------------------*/
/*!
  \brief static utility that returns bisect angle of [left, right].
  this methid can take obtuse angle.
  \param left left start angle
  \param right right end angle
  \return bisect angle
 */
AngleDeg
AngleDeg::bisect( const AngleDeg & left, const AngleDeg & right )
{
    AngleDeg result( left );
    AngleDeg rel( right );
    rel -= left;
    double half_deg = rel.degree() * 0.5;
    result += half_deg;

    if ( left.isLeftOf( right ) )
    {
        return result;
    }
    else
    {
        return result += 180.0;
    }
}

} // end of namespace
