// -*-c++-*-

/*!
	\file handler.h
	\brief rcg data handler Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	 02111-1307	 USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCTOOLS_RCSC_RCG_HANDLER_H
#define RCTOOLS_RCSC_RCG_HANDLER_H

#include <iostream>
#include <rcsc/rcg/types.h>

namespace rcsc {
namespace rcg {

/*!
	\brief abstract rcg data handler class.

	This is an interface class, all member methods are virtual.
*/
class Handler {
private:
		//! RCG version number(1-3, default:0)
		int M_log_version;

public:
		//! constructor
		Handler()
				: M_log_version( 0 )
			{ }

		//! virtual destructor
		virtual
		~Handler()
			{ }

		//! records rcg version
		/*!
			This method is virtual.
			You can override this.
			\param ver log version.
			\return always true.
		*/
		virtual
		bool handleLogVersion( const int ver )
			{
					M_log_version = ver;
					return true;
			}

		//! returns rcg version number
		/*!
			This method is virtual.
			You can override this.
			\return rcg version number
		*/
		virtual
		int getLogVersion() const
			{
					return M_log_version;
			}

		//! virtual method
		virtual
		bool handleDispInfo( const dispinfo_t & info ) = 0;

		//! virtual method
		virtual
		bool handleShowInfo( const showinfo_t & info ) = 0;

		//! virtual method
		virtual
		bool handleShortShowInfo2( const short_showinfo_t2 & info ) = 0;

		//! virtual method
		virtual
		bool handleMsgInfo( short board,
												const std::string & msg ) = 0;

		//! virtual method
		virtual
		bool handlePlayMode( char playmode ) = 0;

		//! virtual method
		virtual
		bool handleTeamInfo( const team_t & team_left,
												 const team_t & team_right ) = 0;

		//! virtual method
		virtual
		bool handlePlayerType( const player_type_t & type ) = 0;

		//! virtual method
		virtual
		bool handleServerParam( const server_params_t & param ) = 0;

		//! virtual method
		virtual
		bool handlePlayerParam( const player_params_t & param ) = 0;

		//! virtual method
		virtual
		bool handleEOF() = 0;

};


} // end of namespace
} // end of namespace

#endif
