// -*-c++-*-

/*!
  \file holder.cpp
  \brief rcg data holder Source File.
*/

/*
 *Copyright:

 Copyright (C) 2004 Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#include <iostream>
#include "holder.h"

namespace rcsc {
namespace rcg {

/*-------------------------------------------------------------------*/
/*!
  add new dispinfo_t (rcg v1, monitor v1)
  \param dinfo dispinfo_t struct data
  \retval true if successfully added.
  \retval false mode is incorrect, or failed to add.
*/
bool
Holder::addDispInfo( const dispinfo_t & dinfo )
{
    switch ( ntohs( dinfo.mode ) ) {
    case SHOW_MODE:
        return addShowInfo( dinfo.body.show );
        break;
    case MSG_MODE:
        return addMsgInfo( dinfo.body.msg.board,
                           std::string( dinfo.body.msg.message ) );
        break;
    case DRAW_MODE:
        return addDrawInfo( dinfo.body.draw );
        break;
    default:
        std::cerr << __FILE__ << ':' << __LINE__
                  << " detect unsupported mode ["
                  << static_cast< int >( ntohs( dinfo.mode ) ) << ']'
                  << std::endl;
        break;
    }
    return false;
}

/*-------------------------------------------------------------------*/
/*!
  add new dispinfo_t2 (monitor v2)
  \param dinfo2 dispinfo_t2 struct data
*/
bool
Holder::addDispInfo2( const dispinfo_t2 & dinfo2 )
{
    switch ( ntohs( dinfo2.mode ) ) {
    case SHOW_MODE:
        return addShowInfo2( dinfo2.body.show );
        break;
    case MSG_MODE:
        return addMsgInfo( dinfo2.body.msg.board,
                           std::string( dinfo2.body.msg.message ) );
        break;
    case PT_MODE:
        return addPlayerType( dinfo2.body.ptinfo );
        break;
    case PARAM_MODE:
        return addServerParam( dinfo2.body.sparams );
        break;
    case PPARAM_MODE:
        return addPlayerParam( dinfo2.body.pparams );
        break;
    default:
        std::cerr << __FILE__ << ':' << __LINE__
                  << " detect unsupported mode ["
                  << static_cast< int >( ntohs( dinfo2.mode ) ) << ']'
                  << std::endl;
        break;
    }
    return false;
}

} // end namespace
} // end namespace
