// -*-c++-*-

/*!
  \file holder.h
  \brief rcg data holder Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama


 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCTOOLS_RCSC_RCG_HOLDER_H
#define RCTOOLS_RCSC_RCG_HOLDER_H

#include <string>
#include <rcsc/rcg/types.h>

namespace rcsc {
namespace rcg {

/*!
  data holder interface class

  It is assumed that this class holds entire game log data.
*/
class Holder {
private:

public:

    //! virtual destructor
    virtual
    ~Holder()
      { }

    //! register dispinfo_t (rcg v1, monitor v1)
    virtual
    bool addDispInfo( const dispinfo_t & dinfo );
    //! register dispinfo_t (monitor v2)
    virtual
    bool addDispInfo2( const dispinfo_t2 & dinfo2 );

    //! pure virtual. register showinfo_t (rcg v2, monitor v1)
    virtual
    bool addShowInfo( const showinfo_t & show ) = 0;
    //! pure virtual. register showinfo_t2 (monitor v2 only)
    virtual
    bool addShowInfo2( const showinfo_t2 & show ) = 0;
    //! pure virtual. register short_showinfo_t2 (rcg v3 only)
    virtual
    bool addShortShowInfo2( const short_showinfo_t2 & show2 ) = 0;

    //! pure virtual. register msginfo_t
    virtual
    bool addMsgInfo( const short board, const std::string & msg ) = 0;
    //! pure virtual. register drawinfo_t(rcg v1:v2, monitor v1)
    virtual
    bool addDrawInfo( const drawinfo_t & draw ) = 0;

    //! pure virtual. register playmode
    virtual
    bool addPlayMode( const char pmode ) = 0;
    //! pure virtual. register team_t * 2
    virtual
    bool addTeamInfo( const team_t & team_l, const team_t & team_r ) = 0;

    //! pure virtual. register player_type_t
    virtual
    bool addPlayerType( const player_type_t & ptinfo ) = 0;
    //! pure virtual. register server_params_t
    virtual
    bool addServerParam( const server_params_t & sparams ) = 0;
    //! pure virtual. register player_param_t
    virtual
    bool addPlayerParam( const player_params_t & pparams ) = 0;

};

} // end namespace
} // end namespace

#endif
