// -*-c++-*-

/*!
  \file parser.h
  \brief abstract rcg parser & holder classes Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCTOOLS_RCSC_RCG_PARSER_H
#define RCTOOLS_RCSC_RCG_PARSER_H

#include <iostream>
#include <map>
#include <boost/shared_ptr.hpp>

namespace rcsc {
namespace rcg {

class Handler;

/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/

/*!
  \brief abstract rcg stream parser class
*/
class Parser {
public:
    //! virtual destructor
    virtual
    ~Parser()
      { }

    //! return version number
    virtual
    int version() const = 0;

    //! operation method
    virtual
    bool parse( std::istream & istrm, Handler & handler ) const = 0;
};

/*-------------------------------------------------------------------*/
//! type defenition for convenience
typedef boost::shared_ptr< Parser > ParserPtr;


/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/

/*!
  \brief parser holder.

  This class is singleton.
  To register a parser object, call add(ParserPtr) method.
*/
class ParserHolder {
private:
    typedef std::map< int, ParserPtr > ParserMap;

    //! key = rcg version, value = pointer to the parser object
    ParserMap M_parser_map;

    //! private for singleton
    ParserHolder()
      { }

public:

    //! return the reference to singleton instance
    static ParserHolder& instance();

    //! register new parser.
    bool add( ParserPtr p );

    //! checks & returns log version.
    int parseVersion( std::istream & istrm ) const;

    //! return pointer to the new parser instance
    const
    ParserPtr get( std::istream & istrm ) const;

    //! return pointer to the new parser instance
    const
    ParserPtr get( const int ver ) const;
};

} // end of namespace
} // end of namespace

#endif
