// -*-c++-*-

/*!
  \file parser_v1.cpp
  \brief rcg v1 parser Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "types.h"
#include "handler.h"
#include "parser_v1.h"

namespace rcsc {
namespace rcg {

/*-------------------------------------------------------------------*/
/*!
  \param istrm reference to the imput stream (usually ifstream/gzifstream).
  \param handler reference to the rcg data handler.
  \retval true, if successfuly parsed.
  \retval false, if incorrect format is detected.
*/
bool
ParserV1::parse( std::istream & istrm,
                 Handler & handler ) const
{
    // streampos must be the first point!!!
    istrm.seekg( 0 );
    if ( ! istrm.good() )
    {
        return false;
    }

    // register log version
    // Because rcg v1 does not contain version information,
    // REC_OLD_VERSION is set without reading.
    handler.handleLogVersion( REC_OLD_VERSION );

    dispinfo_t info;
    while ( istrm.good() )
    {
        istrm.read( reinterpret_cast< char* >( &info ), sizeof( dispinfo_t ) );
        if ( istrm.gcount() != sizeof( dispinfo_t ) )
        {
            return false;
        }

        // check cycle order and so on.
        if ( ! handler.handleDispInfo( info ) )
        {
            return false;
        }
    }

    if ( istrm.eof() )
    {
        return true;
    }

    return false;
}

} // end of namespace
} // end of namespace
