// -*-c++-*-

/*!
  \file parser_v2.h
  \brief rcg v2 parser Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCTOOLS_RCSC_RCG_PARSER_V2_H
#define RCTOOLS_RCSC_RCG_PARSER_V2_H

#include <rcsc/rcg/parser.h>

namespace rcsc {
namespace rcg {

//! rcg v2 parser class
class ParserV2
    : public Parser {
public:

    //! return version number
    int version() const
      {
          return REC_VERSION_2;
      }

    //! operation method
    bool parse( std::istream & istrm, Handler & handler ) const;

private:
    //! parse data block.
    bool parseData( std::istream & istrm, Handler & handler ) const;
};

} // end of namespace
} // end of namespace

#endif
