// -*-c++-*-

/*!
  \file parser_v3.h
  \brief rcg v3 parser Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCTOOLS_RCSC_RCG_PARSER_V3_H
#define RCTOOLS_RCSC_RCG_PARSER_V3_H

#include <rcsc/rcg/parser.h>

namespace rcsc {
namespace rcg {

//! rcg v3 parser class
class ParserV3
    : public Parser {
public:

    /*!
      \brief return version number
      \retval value of version number
     */
    int version() const
      {
          return REC_VERSION_3;
      }

    //! main operation method
    bool parse( std::istream & istrm, Handler & handler ) const;

private:
    //! parse data block.
    bool parseData( std::istream & istrm, Handler & handler ) const;
    //! parse short_showinfo_t2
    bool parseShowInfo( std::istream & istrm, Handler & handler ) const;
    //! parse msg_info_t
    bool parseMsgInfo( std::istream & istrm, Handler & handler ) const;
    //! parse playmode
    bool parsePlayMode( std::istream & istrm, Handler & handler ) const;
    //! parse team_t * 2
    bool parseTeamInfo( std::istream & istrm, Handler & handler ) const;
    //! parse player_type_t
    bool parsePlayerType( std::istream & istrm, Handler & handler ) const;
    //! parse server_params_t
    bool parseServerParam( std::istream & istrm, Handler & handler ) const;
    //! parse player_params_t
    bool parsePlayerParam( std::istream & istrm, Handler & handler ) const;
};

} // end of namespace
} // end of namespace

#endif
