// -*-c++-*-

/*!
  \file util.h
  \brief utilities for rcg data Header File.
*/

/*
 *Copyright:

 Copyright (C) 2004 Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCTOOLS_RCSC_RCG_UTIL_H
#define RCTOOLS_RCSC_RCG_UTIL_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#include "types.h"

namespace rcsc {
namespace rcg {

/*-------------------------------------------------------------------*/
/*!
  convert network short value -> integer
*/
inline
int
nstohi( const short val )
{
    return static_cast< int >( static_cast< short >( ntohs( val ) ) );
}

/*-------------------------------------------------------------------*/
/*!
  convert network short value -> bool
*/
inline
bool
nstohb( const short val )
{
    return static_cast< bool >( static_cast< short >( ntohs( val ) ) );
}

/*-------------------------------------------------------------------*/
/*!
  convert network short value -> real number
*/
inline
double
nstohd( const short val )
{
    return ( static_cast< double >( static_cast< short >( ntohs( val ) ) )
             / SHOWINFO_SCALE );
}

/*-------------------------------------------------------------------*/
/*!
  convert network long value -> real number
  for v2 protocol
*/
inline
double
nltohd( const long & val )
{
    return ( static_cast< double >( static_cast< long >( ntohl( val ) ) )
             / SHOWINFO_SCALE2 );
}

/*-------------------------------------------------------------------*/
/*!
  convert network value of real number.
  v1 protocol -> v2 protocol
*/
inline
long
nstonl( const short val )
{
    return ( static_cast< long >
             ( htonl( static_cast< long >( nstohd( val ) * SHOWINFO_SCALE2 ) ) ) );
}

/*-------------------------------------------------------------------*/
/*!
  convert network value of real number.
  convert v2 protocol -> v1 protocol
*/
inline
short
nltons( const long & val )
{
    return ( static_cast< short >
             ( htons( static_cast< short >( nltohd( val ) * SHOWINFO_SCALE ) ) ) );
}

} // end namespace
} // end namespace

#endif
