// -*-c++-*-

/*!
  \file cmd_line_parser.h
  \brief command line argument parser Header File
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_PARAM_CMD_LINE_PARSER_H
#define RCSC_PARAM_CMD_LINE_PARSER_H

#include <string>
#include <vector>
#include <set>

#include <rcsc/param/param_parser.h>

namespace rcsc {

/*!
  \class CmdLineParser
  \brief command line parser
 */
class CmdLineParser
    : public ParamParser {
private:
    //! copy of command line arguments without program name
    std::vector< std::string > M_args;

    //! if true, warning message is printed.
    bool M_verbose;

    //! positional values
    std::vector< std::string > M_positional_args;

    //! not used
    CmdLineParser();
public:
    /*!
      \brief construct with original command line arguments
      \param argc number of argument
      \param argv const double array of char
     */
    CmdLineParser( const int argc,
                   const char * const * argv );

    /*!
      \brief analyze arguments and results are stored to parameter map
      \param param_map reference to the parameter container
      \return true if successfully parserd
     */
    bool parse( ParamMap & param_map );

    /*!
      \brief get the positional arguments
      \return const reference to the positional arguments container
     */
    const
    std::vector< std::string > & positionalArgs() const
      {
          return M_positional_args;
      }

private:

    /*!
      \brief analyze long name option
      \param param_map reference to the param map instance
      \param long_name option name string
      \param cur_idx index number of the name string in arguments.
      \retval new index value if successfully parsed.
      \retval 0 if failed.
     */
    std::size_t parseLongOption( ParamMap & param_map,
                                 const std::string & long_name,
                                 const std::size_t cur_idx );

    /*!
      \brief analyze short name option
      \param param_map reference to the param map instance
      \param set_name set of the option name character
      \param cur_idx index number of the name string in arguments.
      \retval new index value if successfully parsed.
      \retval 0 if failed.
     */
    std::size_t parseShortOption( ParamMap & param_map,
                                  const std::string & short_name,
                                  const std::size_t cur_idx );

};

}

#endif
