// -*-c++-*-

/*!
  \file segment_2d.cpp
  \brief 2D segment line class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa Akiyama

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream>

#include "segment_2d.h"

namespace rcsc {

/*-------------------------------------------------------------------*/
/*!

 */
bool
Segment2D::intersection( const Segment2D & other,
                         Vector2D * sol ) const
{
    Vector2D tmp_sol( Vector2D::INVALID );
    Line2D my_line = this->line();
    Line2D other_line = other.line();

    if ( ! my_line.intersection( other_line, &tmp_sol ) )
    {
        return false;
    }

    // check if intersection point is on the line segment
    if ( ! this->contains( tmp_sol )
         || ! other.contains( tmp_sol ) )
    {
        return false;
    }
    
    if ( sol )
    {
        *sol = tmp_sol;
    }

    return true;

#if 0
    // Following algorithm seems faster ther abover method.
    // In fact, following algorithm slower...

    Vector2D ab = b() - a();
    Vector2D dc = other.a() - other.b();
    Vector2D ad = other.b() - a();

    double det = dc.outerProduct( ab );

    if ( std::fabs( det ) < 0.001 )
    {
        // area size is 0.
        // segments has same slope.
        std::cerr << "Segment2D::intersection()"
                  << " ***ERROR*** parallel segments"
                  << std::endl;
        return false;
    }

    double s = (dc.x * ad.y - dc.y * ad.x) / det;
    double t = (ab.x * ad.y - ab.y * ad.x) / det;
    
    if ( s < 0.0 || 1.0 < s || t < 0.0 || 1.0 < t )
    {
        return false;
    }

    if ( sol )
    {
        sol->assign( a().x + ab.x * s, a().y + ab.y * s );
    }
    return true;
#endif
}

/*-------------------------------------------------------------------*/
/*!

 */
bool
Segment2D::intersection( const Line2D & other,
                         Vector2D * sol ) const
{
    Vector2D tmp_sol( Vector2D::INVALID );
    Line2D my_line = this->line();

    if ( ! my_line.intersection( other, &tmp_sol ) )
    {
        return false;
    }

    // check if intersection point is on the line segment
    if ( ! this->contains( tmp_sol ) )
    {
        return false;
    }
    
    if ( sol )
    {
        *sol = tmp_sol;
    }

    return true;
}

}
