// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef HELIOS_COACH_H
#define HELIOS_COACH_H

#include <vector>
#include <map>
#include <set>

#include <rcsc/types.h>

#include <rcsc/coach/coach_agent.h>

namespace rcsc {
class PlayerType;
}

class SampleCoach
    : public rcsc::CoachAgent {
private:
    typedef std::vector< const rcsc::PlayerType * > PlayerTypePtrCont;

    //! player type assignment mapping. key: unum, value: type id
    std::map< int, rcsc::HeteroID > M_player_type_id;
    //! used player type id set
    std::set< rcsc::HeteroID > M_used_id;

    //! uniform number of players that belongs to center defender
    std::vector< int > M_center_defender_unum;
    //! uniform number of players that belongs to side defender
    std::vector< int > M_side_defender_unum;
    //! uniform number of players that belongs to midfielder
    std::vector< int > M_midfielder_unum;
    //! uniform number of players that belongs to forward
    std::vector< int > M_forward_unum;

public:
    SampleCoach();

    virtual
    ~SampleCoach();

private:

    /*!
      \brief substitute player.

      This methos should be overrided in the derived class
    */
    void doSubstitute();

    void doFirstSubstitute();

    void substituteTo( const std::vector< int > & unum_set,
                       const rcsc::HeteroID id );

    rcsc::HeteroID getFastestType( const PlayerTypePtrCont & candidates );

    rcsc::HeteroID getMidfielderType( const PlayerTypePtrCont & candidates );

    rcsc::HeteroID getDefenderType( const PlayerTypePtrCont & candidates );

protected:

    /*!
      You can override this method.
      But you must call CoachrAgent::doInit() in this method.
    */
    virtual
    bool doInit( rcsc::CmdLineParser & cmd_parser );

    //! main decision
    virtual
    void doAction();

};

#endif
