// -*-c++-*-

/*!
  \file body_shoot.h
  \brief advanced shoot planning and behavior.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_ACTION_BODY_SHOOT_H
#define RCSC_ACTION_BODY_SHOOT_H

#include <rcsc/action/shoot_table.h>

#include <rcsc/player/soccer_action.h>

namespace rcsc {

/*!
  \class Body_Shoot
  \brief advanced shoot planning and behavior.
 */
class Body_Shoot
    : public BodyAction {
private:
    //! cached shoot talbe
    static ShootTable S_shoot_table;

public:
    /*!
      \brief accessible from global.
     */
    Body_Shoot()
      { }

    /*!
      \brief execute action
      \param agent pointer to the agent itself
      \return true if action is performed
     */
    bool execute( PlayerAgent * agent );


    static
    const
    ShootTable & get_shoot_table( const PlayerAgent * agent )
      {
          return S_shoot_table;
      }

};

}

#endif
