// -*-c++-*-

/*!
  \file util.h
  \brief utilities for rcg data Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_RCG_UTIL_H
#define RCSC_RCG_UTIL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#include <rcsc/rcg/types.h>

namespace rcsc {
namespace rcg {

/*-------------------------------------------------------------------*/
/*!
  \brief convert network short value -> integer
  \param val network byte order variable
  \return local byte order integer
*/
inline
int
nstohi( const short val )
{
    return static_cast< int >( static_cast< short >( ntohs( val ) ) );
}

/*-------------------------------------------------------------------*/
/*!
  \brief convert network byte order short value to bool
  \param val network byte order variable
  \return boolean value
*/
inline
bool
nstohb( const short val )
{
    return static_cast< bool >( static_cast< short >( ntohs( val ) ) );
}

/*-------------------------------------------------------------------*/
/*!
  \brief convert network byte order short value to floating point number
  \param val network byte order variable
  \return floating point number filtered by SHOWINFO_SCALE.
*/
inline
double
nstohd( const short val )
{
    return ( static_cast< double >( static_cast< short >( ntohs( val ) ) )
             / SHOWINFO_SCALE );
}

/*-------------------------------------------------------------------*/
/*!
  \brief convert network byte order long value to floating point number
  for rcsmonitor v2 protocol
  \param val network byte order variable
  \return floating point number filtered by SHOWINFO_SCALE2.
*/
inline
double
nltohd( const long & val )
{
    return ( static_cast< double >( static_cast< long >( ntohl( val ) ) )
             / SHOWINFO_SCALE2 );
}

/*-------------------------------------------------------------------*/
/*!
  \brief convert network byle order short value to network byte order long value
  v1 protocol -> v2 protocol.
  \param val network byte order variable
  \return network byte order long value
*/
inline
long
nstonl( const short val )
{
    return ( static_cast< long >
             ( htonl( static_cast< long >( nstohd( val ) * SHOWINFO_SCALE2 ) ) ) );
}

/*-------------------------------------------------------------------*/
/*!
  \brief convert network byte order long value to network byte order short value
  convert v2 protocol -> v1 protocol
  \param val network byte order variable
  \return network byte order short value
*/
inline
short
nltons( const long & val )
{
    return ( static_cast< short >
             ( htons( static_cast< short >( nltohd( val ) * SHOWINFO_SCALE ) ) ) );
}

} // end namespace
} // end namespace

#endif
