// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cstdlib> // exit
#include <cerrno> // errno
#include <cstring> // strerror
#include <csignal> // sigaction

#include <rcsc/common/basic_client.h>

#include "sample_player.h"

#ifdef _MSC_VER
	#include "win_src/StepDebugManager.h"
	#include <afx.h>
	#include <afxdb.h>
	#include <afxctl.h>

	CWinApp theApp;
#endif

#ifdef ROBOCUP_PLAYER

namespace {

SamplePlayer agent;

/*-------------------------------------------------------------------*/
void
sig_exit_handle( int )
{
    std::cerr << "Killed. Exiting..." << std::endl;
    agent.finalize();
    std::exit( EXIT_FAILURE );
}

}

/*-------------------------------------------------------------------*/
int
main( int argc, char **argv )
{
#ifndef _MSC_VER
	
	struct sigaction sig_action;
    sig_action.sa_handler = &sig_exit_handle;
    sig_action.sa_flags = 0;
    if ( sigaction( SIGINT, &sig_action , NULL ) != 0
         || sigaction( SIGTERM, &sig_action , NULL ) != 0
         || sigaction( SIGHUP, &sig_action , NULL ) != 0 )
        /*if ( signal(SIGINT, &sigExitHandle) == SIG_ERR
          || signal(SIGTERM, &sigExitHandle) == SIG_ERR
          || signal(SIGHUP, &sigExitHandle) == SIG_ERR )*/
    {
        std::cerr << __FILE__ << ": " << __LINE__
                  << ": could not set signal handler: "
                  << std::strerror( errno ) << std::endl;
        std::exit( EXIT_FAILURE );
    }

#endif

    rcsc::BasicClient client;

    if ( ! agent.init( &client, argc, argv ) )
    {
        return EXIT_FAILURE;
    }

#ifdef _MSC_VER

	// test

#ifdef _OFFLINE_READ
	CStepDebugManager::Instance()->SetType( CStepDebugManager::OFFLINE_READ );
#elif defined(_WITH_STEPLOG)
	CStepDebugManager::Instance()->SetType( CStepDebugManager::ONLINE_WRITE );
#else
	CStepDebugManager::Instance()->SetType( CStepDebugManager::DISABLE );
#endif



	// the OFFLINE_READ means that the world model will be load by file instead of being load by server via network
	if( CStepDebugManager::Instance()->GetType() == CStepDebugManager::OFFLINE_READ ) 
	{
		// initialize MFC and print and error on failure
		if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
		{
			std::cerr << _T("Fatal Error: MFC initialization failed") << endl;
		}

		CStepDebugManager::Instance()->Initialize( &agent, CStepDebugManager::OFFLINE_READ );
	}
	else
	{
#endif

    client.run( &agent );

#ifdef _MSC_VER
	}
#endif

    return EXIT_SUCCESS;
}

#endif