#!/bin/sh

DIR=`dirname $0`

player="${DIR}/helios_player"
coach="${DIR}/helios_coach"
host="localhost"

config="${DIR}/player.conf"
config_dir="${DIR}/formations-433"

coach_config="${DIR}/coach.conf"

sleepprog=sleep
goaliesleep=1
sleeptime=0

DEBUGOPT=""

usage()
{
  (echo "Usage: $0 [options]"
   echo "Possible options are:"
   echo "      --help                print this"
   echo "  -h, --host HOST           specifies server host") 1>&2
}

while [ $# -gt 0 ]
	do
	case $1 in

    --help)
      usage
      exit 0
      ;;

    -h|--host)
      if [ $# -lt 2 ]; then
        usage
        exit 1
      fi
      host=$2
      shift 1
      ;;

    *)
      usage
      exit 1
      ;;
  esac

  shift 1
done

OPT="-h ${host}"
OPT="${OPT} --player-config ${config} --config_dir ${config_dir}"

$player ${OPT} -g &
$sleepprog $goaliesleep

for (( i=2; i<=11; i=$i+1 )) ; do
  $player ${OPT} &
  $sleepprog $sleeptime
done

$coach --coach-config ${coach_config} -h $host -t $teamname &

