// -*-c++-*-

/*!
  \file feditor_dialog.h
  \brief Formation editor operation Dialog class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef FEDIT_DIALOG_H
#define FEDIT_DIALOG_H

#include <boost/weak_ptr.hpp>

class FEditFrame;
class FEditData;

/*!
  \brief formation editor operation dialog
*/
class FEditDialog
    : public wxDialog {
private:

    //! data reference
    boost::weak_ptr< FEditData > M_data_ptr;

    wxTextCtrl * M_training_type_name;

    wxTextCtrl * M_ball_pos_x;
    wxTextCtrl * M_ball_pos_y;

    wxTextCtrl * M_mirror_unum[11];
    wxTextCtrl * M_role_name[11];

    wxTextCtrl * M_pos_x[11];
    wxTextCtrl * M_pos_y[11];


public:
    //! constructor
    explicit
    FEditDialog( FEditFrame * paremt );

    ~FEditDialog();

    void setData( boost::shared_ptr< FEditData > ptr )
      {
          M_data_ptr = ptr;
      }

    void update();

private:
    void connectEvents();
    void createWindows();

    void setDefaultValues();

    //----------------------------------------------
    void handleCloseEvent( wxCloseEvent & event );

    void handleMirrorBall( wxCommandEvent & event );
    void handleApplyToField( wxCommandEvent & event );
};

#endif
