// -*-c++-*-

/*!
	\file mouse_state.h
	\brief mouse state class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.	If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_MOUSE_STATE_H
#define SOCCERWINDOW2_WX_MOUSE_STATE_H

///////////////////////////////////////////////////////////////////////
//! formation editor canvas class
class MouseState {
private:

    bool M_pressed;
    wxPoint M_pressed_point;
    wxPoint M_dragged_point;

public:
    MouseState()
        : M_pressed( false )
        , M_pressed_point( 0, 0 )
        , M_dragged_point( 0, 0 )
          { }


    void pressed( const wxPoint & pos )
      {
          M_pressed = true;
          M_pressed_point = M_dragged_point = pos;
      }
    void released()
      {
          M_pressed = false;
      }
    void moved( const wxPoint & pos )
      {
          if ( M_pressed )
          {
              M_dragged_point = pos;
          }
      }

    bool isPressed() const
      {
          return M_pressed;
      }
    const
    wxPoint & pressedPoint() const
      {
          return M_pressed_point;
      }
    const
    wxPoint & draggedPoint() const
      {
          return M_dragged_point;
      }

    bool isDragged() const
      {
          return ( M_pressed
                   && ( std::abs( M_pressed_point.x - M_dragged_point.x ) > 2
                        || std::abs( M_pressed_point.y - M_dragged_point.y ) > 2 )
                   );
      }

};

#endif
