// -*-c++-*-

/*!
  \file ball.h
  \brief ball data class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_MODEL_BALL_H
#define SOCCERWINDOW2_MODEL_BALL_H

#include <rcsc/rcg/types.h>

/*!
  \brief ball info class

  This class contains ball info by RCG data format.
  But ball_t has local byte order variables.
*/
class Ball {
private:
    rcsc::rcg::ball_t M_data; //!< host byte order log format data.
    bool M_have_delta; //!< true if ball has velocity info.
public:
    //! default constructor
    Ball();

    //! construct from v2 data
    explicit
    Ball( const rcsc::rcg::pos_t & p )
      {
          assign( p );
      }

    //! construct from v3 data
    explicit
    Ball( const rcsc::rcg::ball_t & ball )
      {
          assign( ball );
      }

    //! assign new data
    void assign( const rcsc::rcg::ball_t & ball );

    //! assign new data
    void assign( const rcsc::rcg::pos_t & p );

    void convertTo( rcsc::rcg::ball_t & to ) const;

    void convertTo( rcsc::rcg::pos_t & to ) const;

    /*!
      \brief returns real coordinates value.
      \return real X coordinates of ball
    */
    double x() const
      {
          return static_cast< double >( M_data.x ) / rcsc::rcg::SHOWINFO_SCALE2;
      }

    /*!
      \brief returns real coordinates value.
      \return real Y coordinates of ball
    */
    double y() const
      {
          return static_cast< double >( M_data.y ) / rcsc::rcg::SHOWINFO_SCALE2;
      }

    /*!
      returns whether ball has velocity info.
      \retval true ball has velocity info.
      \retval false ball doesn't have volocity info
    */
    bool hasDelta() const
      {
          return M_have_delta;
      }

    /*!
      \brief returns real velocity value.
      \return real velocity Y of ball
    */
    double deltaX() const
      {
          return ( static_cast< double >( M_data.deltax )
                   / rcsc::rcg::SHOWINFO_SCALE2 );
      }

    /*!
      \brief returns real velocity value.
      \return real velocity Y of ball
    */
    double deltaY() const
      {
          return ( static_cast< double >( M_data.deltay )
                   / rcsc::rcg::SHOWINFO_SCALE2 );
      }
};

#endif
