// -*-c++-*-

/*!
  \file player_type_dialog.cpp
  \brief player type list ialog class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui>

#include "player_type_dialog.h"

#include "main_data.h"

#include <rcsc/common/server_param.h>
#include <rcsc/common/player_type.h>

#include <iostream>
#include <cstdio>

namespace {
const int COL_SIZE = 15; // the number of param string
//const int FONT_SIZE = 10;
//const int CELL_HEIGHT = 18;
}


/*-------------------------------------------------------------------*/
/*!

*/
PlayerTypeDialog::PlayerTypeDialog( QWidget * parent,
                            const MainData & main_data )
    : QDialog( parent, Qt::MSWindowsFixedSizeDialogHint )
    , M_main_data( main_data )
{
    this->setWindowTitle( tr( "Player Type List" ) );

    //QFont font = this->font();
    //font.setPointSize( 8 );
    //this->setFont( font );

    createTable();
}

/*-------------------------------------------------------------------*/
/*!

*/
PlayerTypeDialog::~PlayerTypeDialog()
{
    std::cerr << "delete PlayerTypeDialog" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerTypeDialog::createTable()
{
    QBoxLayout * layout = new QBoxLayout( QBoxLayout::LeftToRight );
    layout->setMargin( 4 );

    M_player_type_table = new QTableWidget( M_main_data.viewHolder().playerTypeCont().size(),
                                            COL_SIZE );

    QFontMetrics metrics = this->fontMetrics();

    {
        QTableWidgetItem * items[14];
        int col = 0;

        items[col] = new QTableWidgetItem( tr( "id" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "0" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "Speed Real/Max" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "1.000 / 1.200" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "AccelStep" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "000" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "AccelMax" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "0.6000" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "StamInc" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "45.00" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "Consume" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "55.00" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "Kickable" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "1.085" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "Decay" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "0.400" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "Inertia" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "5.00" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "DashRate" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "0.00600" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "Size" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "0.300" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "KickMargin" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "0.700" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "KickRand" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "0.00" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "ExtStam" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "100.00" ) ) + 12 );
        ++col;

        items[col] = new QTableWidgetItem( tr( "Effort Max-Min" ) );
        items[col]->setTextAlignment( Qt::AlignLeft );
        M_player_type_table->setHorizontalHeaderItem( col, items[col] );
        M_player_type_table->setColumnWidth( col, metrics.width( tr( "1.000 - 1.000" ) ) + 12 );
        ++col;
    }

    M_player_type_table->horizontalHeader()->setResizeMode( QHeaderView::Interactive );
    //M_player_type_table->horizontalHeader()->setResizeMode( QHeaderView::Custom );
    //M_player_type_table->horizontalHeader()->setResizeMode( QHeaderView::Stretch );
    M_player_type_table->verticalHeader()->hide();
    M_player_type_table->setShowGrid( true );

    M_player_type_table->setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOff );
    M_player_type_table->setVerticalScrollBarPolicy( Qt::ScrollBarAlwaysOff );

    const int ROW_SIZE = M_main_data.viewHolder().playerTypeCont().size();
    for ( int row = 0; row < ROW_SIZE; ++row )
    {
        for ( int col = 0; col < COL_SIZE; ++col )
        {
            QTableWidgetItem * item = new QTableWidgetItem();
            item->setTextAlignment( Qt::AlignRight );
            M_player_type_table->setItem( row, col, item );
        }
        M_player_type_table->setRowHeight( row, metrics.height() + 2 );
    }

    layout->addWidget( M_player_type_table );
    this->setLayout( layout );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerTypeDialog::showEvent( QShowEvent * event )
{
    updateData();

    int total_row_height = M_player_type_table->horizontalHeader()->height();

    const int ROW_SIZE = M_player_type_table->rowCount();
    for ( int i = 0; i < ROW_SIZE; ++i )
    {
        total_row_height += M_player_type_table->rowHeight( i );
    }

    this->resize( M_player_type_table->horizontalHeader()->length() + 12,
                  total_row_height + 12 );

    event->accept();
}

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerTypeDialog::updateData()
{
    if ( ! this->isVisible() )
    {
        return;
    }

    if ( M_player_type_table->rowCount()
         != static_cast< int >( M_main_data.viewHolder().playerTypeCont().size() ) )
    {
        std::cerr << "PlayerTypeDialog::updateData() invalid row count"
                  << M_player_type_table->rowCount()
                  << std::endl;
        M_player_type_table->setRowCount( M_main_data.viewHolder().playerTypeCont().size() );
    }


    char buf[32];

    const int ROW_SIZE = M_player_type_table->rowCount();
    for ( int row = 0; row < ROW_SIZE; ++row )
    {
        std::cerr << "PlayerTypeDialog::updateData() set row " << row
                  << std::endl;

        const rcsc::PlayerType & param = M_main_data.viewHolder().playerType( row );

        int col = 0;

        std::snprintf( buf, 32, "%d", param.id() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%5.3f / %5.3f",
                       param.realSpeedMax(), param.playerSpeedMax() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%d", param.cyclesToReachMaxSpeed() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.4f",
                       rcsc::ServerParam::i().maxPower() * param.dashPowerRate() * param.effortMax() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.2f", param.staminaIncMax() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.2f",
                       param.getOneStepStaminaComsumption( rcsc::ServerParam::i() ) );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.3f", param.playerSize() + param.kickableMargin() + 0.085 );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.3f", param.playerDecay() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.2f", param.inertiaMoment() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.5f", param.dashPowerRate() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.3f", param.playerSize() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.3f", param.kickableMargin() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.2f", param.kickRand() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.2f", param.extraStamina() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );

        std::snprintf( buf, 32, "%.3f - %.3f", param.effortMax(), param.effortMin() );
        M_player_type_table->item( row, col++ )->setText( QString::fromAscii( buf ) );
    }




}
