// -*-c++-*-

/*!
  \file score_board_painter.cpp
  \brief score board painter class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qt.h>

#include "score_board_painter.h"

#include "draw_config.h"
// model
#include "main_data.h"
#include "monitor_view_data.h"

#include <iostream>


/*-------------------------------------------------------------------*/
/*!

*/
ScoreBoardPainter::ScoreBoardPainter( const MainData & main_data )
    : M_main_data( main_data )
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
ScoreBoardPainter::draw( QPainter & painter )
{
    const ViewConfig & vconf = M_main_data.viewConfig();

    if ( ! vconf.isShownScoreBoard() )
    {
        return;
    }

    MonitorViewConstPtr view = M_main_data.getViewData( M_main_data.viewIndex() );

    if ( ! view )
    {
        return;
    }

    const DrawConfig & dconf = DrawConfig::instance();

    int board_left_x = 0;
    int board_top_y = 0;
    int board_width = vconf.canvasWidth();

    painter.setFont( dconf.scoreBoardFont() );
    painter.setPen( dconf.scoreBoardFontPen() );

    //std::cerr << "font = " << painter.font().toString().toStdString()
    //          << std::endl;

    {
        QRect left_rect( board_left_x,
                         board_top_y,
                         board_width/3,
                         vconf.scoreBoardHeight() );

        painter.fillRect( left_rect, dconf.leftTeamBrush() );

        QString temp_str;
        if ( view->leftTeam().name().empty() )
        {
            temp_str = QString::fromAscii( "left team" );
        }
        else
        {
            char buf[32];
            std::snprintf( buf, 32,
                           "%s  %d",
                           view->leftTeam().name().c_str(),
                           view->leftTeam().score() );
            temp_str = QString::fromAscii( buf );
        }

        painter.drawText( left_rect,
                          Qt::AlignCenter,
                          temp_str );
    }
    {
        QRect right_rect( board_left_x + board_width*2/3 + 1,
                          board_top_y,
                          board_width/3,
                          vconf.scoreBoardHeight() );

        painter.fillRect( right_rect, dconf.rightTeamBrush() );

        QString temp_str;
        if ( view->rightTeam().name().empty() )
        {
            temp_str = QString::fromAscii( "right team" );
        }
        else
        {
            char buf[32];
            std::snprintf( buf, 32,
                           "%s  %d",
                           view->rightTeam().name().c_str(),
                           view->rightTeam().score() );
            temp_str = QString::fromAscii( buf );
        }

        painter.drawText( right_rect,
                          Qt::AlignCenter,
                          temp_str );
    }
    {
        QRect time_rect( board_width/3 - 1,
                         board_top_y,
                         board_width/3 + 2,
                         vconf.scoreBoardHeight() );

        painter.fillRect( time_rect, dconf.scoreBoardBrush() );

        char buf[32];
        std::snprintf( buf, 32,
                       "%s  %4ld",
                       view->playmode().name().c_str(),
                       view->cycle() );

        painter.drawText( time_rect,
                          Qt::AlignCenter,
                          QString::fromAscii( buf ) );
    }

}
