// -*-c++-*-

/*!
  \file debug_log_dir_dialog.h
  \brief Debug log file directory selector dialog Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_DEBUG_LOG_DIR_DIALOG_H
#define SOCCERWINDOW2_DEBUG_LOG_DIR_DIALOG_H

#include <rcsc/types.h>

class wxButton;
class wxChoice;
class wxSizer;
class wxTextCtrl;

/*!
  \class DebugLogDirDialog
  \brief debug log directory selector dialog
 */
class DebugLogDirDialog
    : public wxDialog {
private:
    wxRadioBox * M_side_select_rb;

    wxTextCtrl * M_log_dir;
    wxButton * M_select_dir_btn;

public:

    DebugLogDirDialog( wxWindow * parent );

    ~DebugLogDirDialog();

    rcsc::SideID getSide() const;
    std::string getDirPath() const;

private:

    void createControls();
    void connectEvents();

    wxSizer * createDirSelectControls( wxWindow * parent );
    wxSizer * createAnswerControls( wxWindow * parent );

    void handleSelectDirButton( wxCommandEvent & event );
    void handleOkButton( wxCommandEvent & event );
};

#endif
