// -*-c++-*-

/*!
  \file debug_message_frame.h
  \brief debug message viewer class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_DEBUG_MESSAGE_FRAME_H
#define SOCCERWINDOW2_WX_DEBUG_MESSAGE_FRAME_H

#include <boost/shared_ptr.hpp>
#include <boost/signals.hpp>

#include <rcsc/types.h>

class MainData;
class MainFrame;
class DebugLogHolder;

class wxNotebook;
class wxNotebookEvent;

//! debug manager frame class
class DebugMessageFrame
    : public wxFrame {
private:

    MainData & M_main_data;

    //! debug log data holder
    boost::shared_ptr< DebugLogHolder > M_debug_holder;

    wxNotebook * M_notebook;
    wxTextCtrl * M_message[11];

    //! log level flag
    int M_level;

    //! not used
    DebugMessageFrame();
    //! noncopyable
    DebugMessageFrame( const DebugMessageFrame & );
    //! noncopyable
    DebugMessageFrame & operator=( const DebugMessageFrame & );

public:

    DebugMessageFrame( wxWindow * parent,
                       MainData & main_data );

    ~DebugMessageFrame();

private:

    void loadConfig();
    void saveConfig();

    void createWindows();
    void createMenuBar();
    void createToolBar();

    void connectEvents();

    void loadDebugLogDir( const rcsc::SideID side,
                          const std::string & dir_path );

protected:

    void handleCloseEvent( wxCloseEvent & event );

private:
    // slots

    void changeCurrentTab( wxNotebookEvent & event );

    void toggleShowDebugViewAll( wxCommandEvent & event );
    void toggleShowDebugViewSelf( wxCommandEvent & event );
    void toggleShowDebugViewBall( wxCommandEvent & event );
    void toggleShowDebugViewPlayers( wxCommandEvent & event );
    void toggleShowDebugViewComment( wxCommandEvent & event );
    void toggleShowDebugViewFigure( wxCommandEvent & event );
    void toggleShowDebugViewTarget( wxCommandEvent & event );
    void toggleShowDebugViewMessage( wxCommandEvent & event );

    void showDebugLogDirDialog( wxCommandEvent & event );

    void syncCycle( wxCommandEvent & event );
    void decrementCycle( wxCommandEvent & event );
    void incrementCycle( wxCommandEvent & event );

    void toggleDebugLevel_1( wxCommandEvent & event );
    void toggleDebugLevel_2( wxCommandEvent & event );
    void toggleDebugLevel_3( wxCommandEvent & event );
    void toggleDebugLevel_4( wxCommandEvent & event );
    void toggleDebugLevel_5( wxCommandEvent & event );
    void toggleDebugLevel_6( wxCommandEvent & event );
    void toggleDebugLevel_7( wxCommandEvent & event );
    void toggleDebugLevel_8( wxCommandEvent & event );
    void toggleDebugLevel_9( wxCommandEvent & event );
    void toggleDebugLevel_10( wxCommandEvent & event );
    void toggleDebugLevel_11( wxCommandEvent & event );
    void toggleDebugLevel_12( wxCommandEvent & event );
    void toggleDebugLevel_13( wxCommandEvent & event );
    void toggleDebugLevel_14( wxCommandEvent & event );
    void toggleDebugLevel_15( wxCommandEvent & event );
    void toggleDebugLevel_16( wxCommandEvent & event );


    void syncCycleOf( const int selection );

public:
    // slots

    void clearAll();
    void updateMessage();
    void updateMessage( const int selection );

public:
    // signals

    boost::signal< void() > emit_configured;
};

#endif
