// -*-c++-*-

/*!
  \file field_painter.h
  \brief field painter class Header File.
*/

/*
 *Copyright:

 Copyright (C) 2004 Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_FIELD_PAINTER_H
#define SOCCERWINDOW2_WX_FIELD_PAINTER_H

#include "painter_interface.h"

class ViewConfig;

class FieldPainter
    : private PainterInterface {
private:

    const ViewConfig & M_conf;

    FieldPainter();

public:

    explicit
    FieldPainter( const ViewConfig & conf )
        : M_conf( conf )
      { }

    /*!
      \brief draw soccer field and stationary objects
      \param dc reference to the device context
    */
    void draw( wxDC & dc ) const;

private:
    /*!
      \brief draw back ground
      \param dc reference to the device context
    */
    void drawBackGround( wxDC & dc ) const;
    /*!
      \brief draw line type grass
      \param dc reference to the device context
    */
    void drawLinesGrass( wxDC & dc ) const;

    /*!
      \brief draw checker type grass
      \param dc reference to the device context
    */
    void drawCheckerGrass( wxDC & dc ) const;

    /*!
      \brief draw field lines
      \param dc reference to the device context
    */
    void drawLines( wxDC & dc ) const;

    /*!
      \brief draw penalty area
      \param dc reference to the device context
    */
    void drawPenaltyAreaLines( wxDC & dc ) const;

    /*!
      \brief draw goal area
      \param dc reference to the device context
    */
    void drawGoalAreaLines( wxDC & dc ) const;
    /*!
      \brief draw goals
      \param dc reference to the device context
    */
    void drawGoals( wxDC & dc ) const;

    /*!
      \brief draw flags
      \param dc reference to the device context
    */
    void drawFlags( wxDC & dc ) const;

};

#endif
