// -*-c++-*-

/*!
  \file id.h
  \brief ID List Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_ID_H
#define SOCCERWINDOW2_WX_ID_H

enum {
    SWID_SOCCER_WINDOW_APP = 100,

    // global command event IDs
    SWID_QUIT,
    SWID_SHOW_ABOUT_DIALOG,
    SWID_SHOW_OPEN_RCG_DIALOG, // file open
    SWID_SHOW_SAVE_RCG_DIALOG, // file save
    SWID_SHOW_OPEN_DEBUG_VIEW_DIR_DIALOG, // debug view data open
    SWID_SHOW_SAVE_DEBUG_VIEW_DIR_DIALOG, // debug view data save
    SWID_SHOW_CONNECT_DIALOG, // text entry
    SWID_SHOW_PLAYER_TYPE_DIALOG,
    SWID_SHOW_DETAIL_DIALOG,
    SWID_SHOW_IMAGE_SAVE_DIALOG,
    SWID_SHOW_VIEW_CONFIG_DIALOG,
    SWID_SHOW_DEBUG_MESSAGE_FRAME,

    // window IDs
    SWID_STATUSBAR,

    // toolbar
    SWID_LOGPLAYER_TOOLBAR,
    SWID_SLIDER_LOGPLAYER,
    SWID_TEXTBOX_LOGPLAYER,

    SWID_DEBUG_TOOLBAR,

    SWID_FIELD_SCALE_SLIDER,
    SWID_VORONOI_CHOICE,

    SWID_TEXTBOX_BALL_TRACE_START,
    SWID_TEXTBOX_BALL_TRACE_END,
    SWID_TEXTBOX_PLAYER_TRACE_START,
    SWID_TEXTBOX_PLAYER_TRACE_END,
    SWID_TEXTBOX_AUTO_TRACE_START,
    SWID_TEXTBOX_AUTO_TRACE_PERIOD,
    SWID_TEXTBOX_BALL_FUTURE_CYCLE,
    SWID_TEXTBOX_PLAYER_FUTURE_CYCLE,

    // image save dialog controls
    SWID_IMAGE_SAVE_SELECT_ALL,
    SWID_IMAGE_SAVE_SELECT_DIR,
    SWID_IMAGE_SAVE_EXECUTE,

    // debug message frame
    SWID_FRAME_DEBUG_MESSAGE,
    SWID_TEXTBOX_LOGLEVEL_MIN,
    SWID_TEXTBOX_LOGLEVEL_MAX,
    SWID_NOTEBOOK_DEBUG_MESSAGE,

    // popup menu ID
    SWID_MENU_MONITOR_DROPBALL,
    SWID_MENU_MONITOR_FREEKICK_LEFT,
    SWID_MENU_MONITOR_FREEKICK_RIGHT,
    SWID_MENU_MONITOR_DROPBALL_THERE,

    // submenu ID
    SWID_SUBMENU_GRASS_TYPE,

    // timer ID
    SWID_TIMER_MONITOR,
    SWID_TIMER_DEBUG_SERVER,
    SWID_TIMER_LOGPLAYER,

    /////////////////////////////////////////////////
    SWID_MAIN_FRAME_COMMAND_BEGIN,

    // menu command event IDs
    SWID_TOGGLE_MENUBAR,
    SWID_TOGGLE_TOOLBAR,
    SWID_TOGGLE_STATUSBAR,
    SWID_TOGGLE_MAXIMIZE,
    SWID_TOGGLE_FULLSCREEN,

    // monitor command IDs
    SWID_MONITOR_CONNECT,
    SWID_MONITOR_DISCONNECT,
    SWID_MONITOR_KICKOFF,
    SWID_MONITOR_DROPBALL,
    SWID_MONITOR_FREEKICK_LEFT,
    SWID_MONITOR_FREEKICK_RIGHT,
    SWID_MONITOR_MOVE_PLAYER,
    SWID_MONITOR_DISCARD_PLAYER,
    SWID_MONITOR_CHANGE_PLAYMODE,

    // logplayer command IDs

    SWID_LOGPLAYER_SET_INDEX,
    SWID_LOGPLAYER_STOP,
    SWID_LOGPLAYER_PLAY_BACK,
    SWID_LOGPLAYER_PLAY_FORWARD,
    SWID_LOGPLAYER_PLAY_OR_STOP,
    SWID_LOGPLAYER_STEP_BACK,
    SWID_LOGPLAYER_STEP_FORWARD,
    SWID_LOGPLAYER_GOTO_FIRST,
    SWID_LOGPLAYER_GOTO_LAST,
    SWID_LOGPLAYER_GOTO_PREV_SCORE,
    SWID_LOGPLAYER_GOTO_NEXT_SCORE,
    SWID_LOGPLAYER_DECELERATE,
    SWID_LOGPLAYER_ACCELERATE,
    SWID_LOGPLAYER_GOTO_INDEX,
    SWID_LOGPLAYER_GOTO_CYCLE,
    SWID_LOGPLAYER_AUTO_LOOP,

    SWID_REQUEST_LIVE_MODE,

    SWID_REQUEST_KILL_SERVER,
    SWID_REQUEST_RESTART_SERVER,

    // canvas event IDs
    SWID_CANVAS_LOAD_SIZE_BUTTON,
    SWID_CANVAS_SET_SIZE_BUTTON,
    SWID_CANVAS_ZOOMIN,
    SWID_CANVAS_ZOOMOUT,
    SWID_CANVAS_UNZOOM,
    SWID_CANVAS_ENLARGE,
    SWID_CANVAS_DRAW_SCORE_BOARD,
    SWID_CANVAS_DRAW_BALL,
    SWID_CANVAS_DRAW_PLAYER,
    SWID_CANVAS_DRAW_PLAYER_NUMBER,
    SWID_CANVAS_DRAW_STAMINA,
    SWID_CANVAS_DRAW_HETERO_NUMBER,
    SWID_CANVAS_DRAW_VIEW_CONE,
    SWID_CANVAS_DRAW_CONTROL_AREA,
    SWID_CANVAS_DRAW_FLAGS,
    SWID_CANVAS_DRAW_OFFSIDE_LINE,
    SWID_CANVAS_DRAW_VORONOI_DIAGRAM,
    SWID_CANVAS_DRAW_DELAUNAY_TRIANGLE,
    SWID_CANVAS_KEEPAWAY_MODE,
    SWID_CANVAS_GRASS_LINES,
    SWID_CANVAS_GRASS_CHECKER,
    SWID_CANVAS_GRASS_NORMAL,
    SWID_CANVAS_FOCUS_POINT,
    SWID_CANVAS_FOCUS_BALL,
    SWID_CANVAS_FOCUS_PLAYER,
    SWID_CANVAS_FOCUS_FIX,
    SWID_CANVAS_SELECT_AUTO_ALL,
    SWID_CANVAS_SELECT_AUTO_LEFT,
    SWID_CANVAS_SELECT_AUTO_RIGHT,
    SWID_CANVAS_SELECT_FIX,
    SWID_CANVAS_SELECT_PLAYER,
    SWID_CONFIG_PLAYER_CHOICE,
    SWID_CANVAS_UNSELECT_PLAYER,
    SWID_CANVAS_TOGGLE_TRACE_SHAPE,
    SWID_CANVAS_TOGGLE_BALL_AUTO_TRACE,
    SWID_CANVAS_TOGGLE_PLAYER_AUTO_TRACE,
    SWID_CANVAS_BALL_TRACE_SELECT_ALL,
    SWID_CANVAS_PLAYER_TRACE_SELECT_ALL,

    // debug server
    SWID_DEBUG_SERVER_START,
    SWID_DEBUG_SERVER_STOP,

    SWID_MAIN_FRAME_COMMAND_END,

    // end of main frame commands
    ///////////////////////////////////////////////////////////
    // debug message frame commands

    SWID_DEBUG_FRAME_COMMAND_BEGIN,

    // visual debugger
    SWID_CANVAS_DRAW_DEBUG_VIEW,
    SWID_CANVAS_DRAW_DEBUG_VIEW_BALL,
    SWID_CANVAS_DRAW_DEBUG_VIEW_SELF,
    SWID_CANVAS_DRAW_DEBUG_VIEW_PLAYERS,
    SWID_CANVAS_DRAW_DEBUG_VIEW_COMMENT,
    SWID_CANVAS_DRAW_DEBUG_VIEW_FIGURE,
    SWID_CANVAS_DRAW_DEBUG_VIEW_TARGET,
    SWID_CANVAS_DRAW_DEBUG_VIEW_MESSAGE,

    // debug log directory
    SWID_SHOW_DEBUG_LOG_DIR_DIALOG,
    SWID_SELECT_DEBUG_DIR, // on dir selector dialog

    SWID_DEBUG_LOG_SYNC,
    SWID_DEBUG_LOG_DECREMENT,
    SWID_DEBUG_LOG_INCREMENT,

    // debug log message level buttons
    SWID_DEBUG_LEVEL_1,
    SWID_DEBUG_LEVEL_2,
    SWID_DEBUG_LEVEL_3,
    SWID_DEBUG_LEVEL_4,
    SWID_DEBUG_LEVEL_5,
    SWID_DEBUG_LEVEL_6,
    SWID_DEBUG_LEVEL_7,
    SWID_DEBUG_LEVEL_8,
    SWID_DEBUG_LEVEL_9,
    SWID_DEBUG_LEVEL_10,
    SWID_DEBUG_LEVEL_11,
    SWID_DEBUG_LEVEL_12,
    SWID_DEBUG_LEVEL_13,
    SWID_DEBUG_LEVEL_14,
    SWID_DEBUG_LEVEL_15,
    SWID_DEBUG_LEVEL_16,

    SWID_DEBUG_FRAME_COMMAND_END,
    // end of debug message frame commands
    ///////////////////////////////////////////////////////////

};

#endif
