// -*-c++-*-

/*!
  \file image_save_dialog.h
  \brief Field Canvas image save control dialog class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_IMAGE_SAVE_DIALOG_H
#define SOCCERWINDOW2_WX_IMAGE_SAVE_DIALOG_H

class wxButton;
class wxChoice;
class wxSizer;
class wxSpinCtrl;
class wxTextCtrl;

class FieldCanvas;
class MainData;
class MainFrame;

//! image save manager
class ImageSaveDialog
    : public wxDialog {
private:

    MainFrame * M_main_frame;
    FieldCanvas * M_field_canvas;

    MainData & M_main_data;

    wxSpinCtrl * M_start_cycle;
    wxSpinCtrl * M_end_cycle;
    wxButton * M_select_all_btn;

    wxTextCtrl * M_name_prefix;
    wxChoice * M_format_choice;

    wxTextCtrl * M_saved_dir;
    wxButton * M_select_dir_btn;

    wxButton * M_execute_btn;
public:
    //! constructor
    ImageSaveDialog( MainFrame * main_frame,
                     FieldCanvas * field_canvas,
                     MainData & main_data );

    ~ImageSaveDialog();

    virtual
    bool Show( bool show = true );
private:

    void createControls();
    void connectEvents();

    wxSizer * createCycleSelectControls( wxWindow * parent );
    wxSizer * createFileNameControls( wxWindow * parent );
    wxSizer * createDirSelectControls( wxWindow * parent );
    wxSizer * createExecuteControls( wxWindow * parent );

    void handleCloseEvent( wxCloseEvent & event );

    void handleSelectAllButton( wxCommandEvent & event );
    void handleSelectDirButton( wxCommandEvent & event );
    void handleExecuteButton( wxCommandEvent & event );


    void saveImage( const int start_cycle,
                    const int end_cycle,
                    const wxString & saved_dir,
                    const wxString & name_prefix,
                    const int format_type );
};

#endif
