// -*-c++-*-

/*!
  \file log_player.h
  \brief log player Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_LOG_PLAYER_H
#define SOCCERWINDOW2_WX_LOG_PLAYER_H

#include <boost/signals.hpp>

class MainData;

//! logplayer class.
class LogPlayer
    : public wxEvtHandler {
private:

    MainData & M_main_data;

    //! timer event invoker
    wxTimer M_timer;

    //! if true, play direction is forward
    bool M_forward;

    //! if true, latest monitor view data is requested.
    bool M_live_mode;

    //! not used
    LogPlayer();
    //! nocopyable
    LogPlayer( const LogPlayer & );
    //! nocopyable
    LogPlayer& operator=( const LogPlayer & );

public:

    explicit
    LogPlayer( MainData & main_data );

    bool isLiveMode() const
      {
          return M_live_mode;
      }

private:

    void stepBackImpl();
    void stepForwardImpl();

private:
    //--------------------------------------
    //! timer event handler
    void handleTimer( wxTimerEvent & event );

public:

    // slots

    void stepBack();
    void stepForward();

    void playOrStop();
    void stop();

    void playBack();
    void playForward();

    void goToPrevScore();
    void goToNextScore();

    void goToFirst();
    void goToLast();

    void decelerate();
    void accelerate();

    void goToIndex( int index );

    void goToCycle( int cycle );

    void showLive();

    void setLiveMode();

public:

    // signal
    boost::signal< void() > emit_updated;

};

#endif
