// -*-c++-*-

/*!
  \file log_player_tool_bar.h
  \brief LogPlayer Toolbar class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_LOG_PLAYER_TOOL_BAR_H
#define SOCCERWINDOW2_WX_LOG_PLAYER_TOOL_BAR_H

#include <boost/signals.hpp>

class LogPlayer;
class MainData;

class LogPlayerToolBar
    : public wxToolBar {
private:

    const MainData & M_main_data;

    //! cycle controller
    wxSlider * M_cycle_slider;
    //! cycle controller
    wxTextCtrl * M_cycle_text_box;

    //! not used
    LogPlayerToolBar();
    //! not used
    LogPlayerToolBar( const LogPlayerToolBar & );
    //! not used
    LogPlayerToolBar & operator=( const LogPlayerToolBar & );
public:

    LogPlayerToolBar( wxWindow * parent,
                      const long & style,
                      const MainData & main_data );

    ~LogPlayerToolBar();

private:
    void createTools();

    //! slider factory
    wxSlider * createCycleSlider( wxWindow * parent );
    //! text box factory
    wxTextCtrl * createCycleTextBox( wxWindow * parent );

    void connectEvents();

    //! event handler
    void handleSliderScroll( wxScrollEvent & event );
    //! event handler
    void handleCycleTextEnter( wxCommandEvent & event );

public:

    // slots
    void updateSlider();

public:

    // signals
    boost::signal< void ( int ) > emit_cycleChanged;
    boost::signal< void ( int ) > emit_indexChanged;
};

#endif
