// -*-c++-*-

/*!
  \file main_frame.h
  \brief main application frame class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_MAIN_FRAME_H
#define SOCCERWINDOW2_WX_MAIN_FRAME_H

#include "main_data.h"

#include <boost/shared_ptr.hpp>
#include <boost/signals.hpp>

class DebugMessageFrame;
class DebugServer;
class DetailDialog;
class FieldCanvas;
class LogPlayer;
class LogPlayerToolBar;
class MonitorClient;
class PlayerTypeDialog;
class ViewConfigDialog;

//! main frame class
class MainFrame
    : public wxFrame {
private:

    //! main data supplier
    MainData M_main_data;

    FieldCanvas * M_field_canvas;

    LogPlayer * M_log_player;

    LogPlayerToolBar * M_log_player_tool_bar;

    DetailDialog * M_detail_dialog;
    PlayerTypeDialog * M_player_type_dialog;
    ViewConfigDialog * M_view_config_dialog;

    DebugMessageFrame * M_debug_message;

    boost::shared_ptr< MonitorClient > M_monitor_client;
    boost::shared_ptr< DebugServer > M_debug_server;

    //! not used
    MainFrame();
    MainFrame( const MainFrame & );
    const MainFrame & operator=( const MainFrame & );

public:

    explicit
    MainFrame( const wxString & title );

    ~MainFrame();

    //! initialize application settings using command line options.
    void init();

private:

    //--------------------------------------------------
    //! load settings from config file
    void loadConfig();
    //! save settings to config file
    void saveConfig();

    //! set event table
    void connectEvent();

    //--------------------------------------------------
    // create window objects

    //! realize menu bar.
    void createMenuBar();
    wxMenu * createMenuFile();
    wxMenu * createMenuMonitor();
    wxMenu * createMenuView();
    wxMenu * createMenuTool();
    wxMenu * createMenuHelp();

    //! overrided method
    wxToolBar * OnCreateToolBar( long style, wxWindowID id,
                                 const wxString & name );
    void createToolBar();
    void createStatusBar();

    void createWindows();

protected:

    // wx event handlers
    void handleCloseEvent( wxCloseEvent & event );
    void handleSizeEvent( wxSizeEvent & event );

private:

    void loadRCG( const wxString & file_path );
    void connectMonitorTo( const char * hostname );

private:
    // slots

    //--------------------------------------------------
    // menu actions: file
    void handleOpenRCG( wxCommandEvent & event );
    void handleSaveRCG( wxCommandEvent & event );
    void handleOpenDebugView( wxCommandEvent & event );
    void handleSaveDebugView( wxCommandEvent & event );
    void handleQuit( wxCommandEvent & event );

    // slots: file
    void openRCG();
    void saveRCG();
    void openDebugView();
    void saveDebugView();
    // wxWindow::Close() is used as a quit action's slot.

    // menu actions: monitor
    void handleKickOff( wxCommandEvent & event );
    void handleSetLiveMode( wxCommandEvent & event );
    void handleConnectMonitor( wxCommandEvent & event );
    void handleConnectMonitorTo( wxCommandEvent & event );
    void handleDisconnectMonitor( wxCommandEvent & event );
    void handleKillServer( wxCommandEvent & event );
    void handleRestartServer( wxCommandEvent & event );

    // slots: monitor
    void kickOff();
    void setLiveMode();
    void connectMonitor();
    void connectMonitorTo();
    void disconnectMonitor();
    void killServer();
    void startServer();
    void restartServer();

    // menu actions: view
    void handleToggleToolBar( wxCommandEvent & event );
    void handleToggleStatusBar( wxCommandEvent & event );
    void handleToggleFullScreen( wxCommandEvent & event );
    void handleShowPlayerTypeDialog( wxCommandEvent & event );
    void handleShowDetailDialog( wxCommandEvent & event );
    void handleShowViewConfigDialog( wxCommandEvent & event );

    // slots: view
    void toggleMenuBar();
    void toggleToolBar();
    void toggleStatusBar();
    void toggleFullScreen();
    void showPlayerTypeDialog();
    void showDetailDialog();
    void showViewConfigDialog();

    // menu actions: tool
    void handleShowDebugMessageFrame( wxCommandEvent & event );
    void handleStartDebugServer( wxCommandEvent & event );
    void handleStopDebugServer( wxCommandEvent & event );
    void handleShowImageSaveDialog( wxCommandEvent & event );

    // slots: tool
    void showDebugMessageFrame();
    void startDebugServer();
    void stopDebugServer();
    void showImageSaveDialog();

    // menu actions: help
    void handleAbout( wxCommandEvent & event );

    // slots: help
    void about();

    //--------------------------------------------------
    // tool bar actions
    void clickGoToFirst( wxCommandEvent & event );
    void clickGoToPrevScore( wxCommandEvent & event );
    void clickStepBack( wxCommandEvent & event );
    void clickPlayOrStop( wxCommandEvent & event );
    void clickStepForward( wxCommandEvent & event );
    void clickGoToNextScore( wxCommandEvent & event );
    void clickGoToLast( wxCommandEvent & event );
    void clickDecelerate( wxCommandEvent & event );
    void clickAccelerate( wxCommandEvent & event );

    //--------------------------------------------------
    bool handleShortcutKey( const int key_code,
                            const bool ctrl_down,
                            const bool alt_down,
                            const bool shift_down );

public:
    // slots

    void resizeCanvas( const wxSize & size );

    void receiveMonitorPacket();

    void updatePositionLabel( const wxPoint & point );

    void dropBallThere();
    void dropBall( const wxPoint & pos );
    void freeKickLeft( const wxPoint & pos );
    void freeKickRight( const wxPoint & pos );

public:

    // signals
    boost::signal< void () > emit_viewUpdated;

};

#endif
