// -*-c++-*-

/*!
  \file player_trace_painter.cpp
  \brief player trace painter class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "player_trace_painter.h"

#include "draw_config.h"
// model
#include "main_data.h"
#include "monitor_view_data.h"

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerTracePainter::draw( wxDC & dc ) const
{
    const ViewConfig & vconf = M_main_data.viewConfig();
    if ( vconf.selectedNumber() == 0 )
    {
        return;
    }

    const ViewHolder & holder = M_main_data.viewHolder();

    long start_cycle = vconf.playerTraceStart();
    long end_cycle = vconf.playerTraceEnd();

    const MonitorViewCont & vc = M_main_data.viewHolder().monitorViewCont();

    if ( vc.empty() )
    {
        return;
    }

    if ( vconf.isPlayerAutoTrace() )
    {
        MonitorViewConstPtr view = M_main_data.getViewData( M_main_data.viewIndex() );
        if ( ! view )
        {
            return;
        }
        start_cycle = std::max( 1L, view->cycle() + vconf.autoTraceStart() );
    }
    else if ( start_cycle >= end_cycle )
    {
        return;
    }

    const std::size_t first = holder.getIndexOf( start_cycle );
    const std::size_t last = ( vconf.isPlayerAutoTrace()
                               ? std::min( first + vconf.autoTracePeriod(),
                                           vc.size() - 1 )
                               : holder.getIndexOf( end_cycle ) );
    if ( first >= last )
    {
        return;
    }

    const std::size_t idx = static_cast< std::size_t >
        ( vconf.selectedNumber() > 0
          ? vconf.selectedNumber() - 1
          : 11 + (- vconf.selectedNumber()) - 1 );
    const wxPen & my_pen = ( vconf.selectedNumber() > 0
                             ? DrawConfig::instance().leftTeamPen()
                             : DrawConfig::instance().rightTeamPen() );

    const bool line_trace = vconf.isLineTrace();

    if ( line_trace )
    {
        dc.SetBrush( *wxTRANSPARENT_BRUSH );
    }
    else
    {
        dc.SetBrush( *wxMEDIUM_GREY_BRUSH );
    }

    std::size_t i = first;
    int prev_x = vconf.getScreenX( vc[i]->players()[idx].x() );
    int prev_y = vconf.getScreenY( vc[i]->players()[idx].y() );
    ++i;
    for ( ; i <= last; ++i )
    {
        switch ( vc[i]->playmode().mode() ) {
        case rcsc::PM_BeforeKickOff:
        case rcsc::PM_TimeOver:
        case rcsc::PM_AfterGoal_Left:
        case rcsc::PM_AfterGoal_Right:
            continue;
        case rcsc::PM_PlayOn:
            dc.SetPen( my_pen );
            break;
        default:
            //std::cerr << "playmode = " << vc[i]->playmode().name() << std::endl;
            dc.SetPen( *wxBLACK_DASHED_PEN );
            break;
        }

        const Player & p = vc[i]->players()[idx];
        int ix = vconf.getScreenX( p.x() );
        int iy = vconf.getScreenY( p.y() );
        if ( line_trace )
        {
            dc.DrawLine( prev_x, prev_y, ix, iy );
        }
        else
        {
            dc.DrawLine( prev_x, prev_y, ix, iy );
            dc.DrawCircle( ix, iy, 2 );
        }
        prev_x = ix;
        prev_y = iy;
    }
}
