// -*-c++-*-

/*!
  \file view_config_dialog.h
  \brief View Config Dialog class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_VIEW_CONFIG_DIALOG_H
#define SOCCERWINDOW2_VIEW_CONFIG_DIALOG_H

#include <boost/signals.hpp>

class wxButton;
class wxCheckBox;
class wxChoice;
class wxRadioButton;
class wxSpinCtrl;
class wxSpinEvent;
class wxSizer;
class wxSlider;
class wxStaticText;

class MainData;
class ViewConfig;
class ViewConfigControl;

//! field canvas configuration dialog
class ViewConfigDialog
    : public wxDialog {
private:

    const MainData & M_main_data;
    ViewConfig & M_view_config;

    // zoom contrl
    wxCheckBox * M_enlarge_cb;
    wxSlider * M_scale_slider;
    wxStaticText * M_scale_text;

    // canvas size control
    wxTextCtrl * M_canvas_width_text;
    wxTextCtrl * M_canvas_height_text;
    wxButton * M_set_canvas_size_btn;

    // player detail control
    wxCheckBox * M_player_number_cb;
    wxCheckBox * M_hetero_number_cb;
    wxCheckBox * M_stamina_cb;
    wxCheckBox * M_view_cone_cb;
    wxCheckBox * M_control_area_cb;

    // show/hide control
    wxCheckBox * M_show_score_board_cb;
    wxCheckBox * M_show_ball_cb;
    wxCheckBox * M_show_players_cb;
    wxCheckBox * M_show_flags_cb;
    wxCheckBox * M_show_offside_line_cb;

    // grass type
    wxRadioButton * M_grass_normal_rb;
    wxRadioButton * M_grass_line_rb;
    wxRadioButton * M_grass_checker_rb;

    wxCheckBox * M_keepaway_mode_cb;

    // computational geometyry control
    wxCheckBox * M_show_voronoi_cb;
    wxCheckBox * M_show_delaunay_cb;
    wxChoice * M_voronoi_choice;

    // focus control
    wxRadioButton * M_focus_ball_rb;
    wxRadioButton * M_focus_player_rb;
    wxRadioButton * M_focus_fix_rb;

    // player selection
    wxRadioButton * M_select_all_rb;
    wxRadioButton * M_select_left_rb;
    wxRadioButton * M_select_right_rb;
    wxRadioButton * M_select_fix_rb;
    wxRadioButton * M_unselect_rb;

    wxChoice * M_player_choice;
    //wxButton * M_left_player_btn[11];
    //wxButton * M_right_player_btn[11];

    // trace control
    wxTextCtrl * M_ball_trace_start;
    wxTextCtrl * M_ball_trace_end;
    wxCheckBox * M_ball_trace_cb;
    wxTextCtrl * M_player_trace_start;
    wxTextCtrl * M_player_trace_end;
    wxCheckBox * M_player_trace_cb;

    wxTextCtrl * M_auto_trace_start;
    wxSpinCtrl * M_auto_trace_period;

    // inertia movement control
    wxSpinCtrl * M_ball_future;
    wxSpinCtrl * M_player_future;

public:
    //! constructor
    ViewConfigDialog( wxWindow * parent,
                      const MainData & main_data,
                      ViewConfig & view_config );

    ~ViewConfigDialog();

    // override
    bool Show( bool show = true );

private:

    void createControls();
    wxSizer * createZoomControls();
    wxSizer * createCanvasSizeControls(  wxWindow * parent );
    wxSizer * createPlayersDetailControls();
    wxSizer * createShowControls();
    wxSizer * createCompGeomControls();
    wxSizer * createFocusControls();
    wxSizer * createPlayerSelectionControls();
    wxSizer * createGrassTypeControls();
    wxSizer * createTraceControls();
    wxSizer * createInertiaMoveControls();

    void connectEvents();

protected:

    void handleCloseEvent( wxCloseEvent & event );

private:
    // slots

    void updateAll();

    ///////////////////////////////////////////////////////
    // connect to itself
    // emit configured()

    // zoom actions
    void clickZoomIn( wxCommandEvent & event );
    void clickZoomOut( wxCommandEvent & event );
    void clickFit( wxCommandEvent & event );
    void clickEnlarge( wxCommandEvent & event );
    void slideFieldScale( wxScrollEvent & event );

    // canvas size actions
    void clickSetCanvasSize( wxCommandEvent & event );

    // show/hide actions
    void clickShowPlayerNumber( wxCommandEvent & event );
    void clickShowHeteroNumber( wxCommandEvent & event );
    void clickShowStamina( wxCommandEvent & event );
    void clickShowViewCone( wxCommandEvent & event );
    void clickShowControlArea( wxCommandEvent & event );

    void clickShowScoreBoard( wxCommandEvent & event );
    void clickShowBall( wxCommandEvent & event );
    void clickShowPlayers( wxCommandEvent & event );
    void clickShowFlags( wxCommandEvent & event );
    void clickShowOffsideLine( wxCommandEvent & event );

    // grass type actions
    void clickGrassNormal( wxCommandEvent & event );
    void clickGrassLine( wxCommandEvent & event );
    void clickGrassChecker( wxCommandEvent & event );

    void clickKeepawayMode( wxCommandEvent & event );

    // computational geometry show/hide actions
    void clickShowVoronoiDiagram( wxCommandEvent & event );
    void clickShowDelaunayTrianglation( wxCommandEvent & event );
    void selectCompGeomSide( wxCommandEvent & event );

    // focus type actions
    void clickFocusBall( wxCommandEvent & event );
    void clickFocusPlayer( wxCommandEvent & event );
    void clickFocusFix( wxCommandEvent & event );

    // player selection type actions
    void clickSelectAutoAll( wxCommandEvent & event );
    void clickSelectAutoLeft( wxCommandEvent & event );
    void clickSelectAutoRight( wxCommandEvent & event );
    void clickSelectFix( wxCommandEvent & event );
    void clickUnselect( wxCommandEvent & event );

    void selectPlayer( wxCommandEvent & event );

    // trace control actions
    void editBallTraceStart( wxCommandEvent & event );
    void editBallTraceEnd( wxCommandEvent & event );
    void clickBallTraceAll( wxCommandEvent & event );
    void clickAutoBallTrace( wxCommandEvent & event );

    void editPlayerTraceStart( wxCommandEvent & event );
    void editPlayerTraceEnd( wxCommandEvent & event );
    void clickPlayerTraceAll( wxCommandEvent & event );
    void clickAutoPlayerTrace( wxCommandEvent & event );

    void editAutoTraceStart( wxCommandEvent & event );
    void changeAutoTracePeriod( wxSpinEvent & event );

    void clickLinePointButton( wxCommandEvent & event );

    // ienrtia trace actions
    void changeBallFutureCycle( wxSpinEvent & event );
    void changePlayerFutureCycle( wxSpinEvent & event );

public:
    // slots

    // just update this dialog contents
    // no emit
    void updateFieldScale();

    // connect to other objects
    // emit configured()
    void zoomIn();
    void zoomOut();
    void unzoom();
    void toggleEnlarge();

    void applyCanvasSize();

    void toggleShowPlayerNumber();
    void toggleShowHeteroNumber();
    void toggleShowStamina();
    void toggleShowViewCone();
    void toggleShowControlArea();

    void toggleShowScoreBoard();
    void toggleShowPlayers();
    void toggleShowBall();
    void toggleShowFlags();
    void toggleShowOffsideLine();

    void toggleFocusBall();
    void toggleFocusPlayer();
    void setFocusFix();
    void setFocusPoint( const wxPoint & point );

    void toggleSelectAutoAll();
    void toggleSelectAutoLeft();
    void toggleSelectAutoRight();
    void toggleSelectFix();
    void setUnselect();

    void selectPlayerNumber( int number );

    void toggleKeepawayMode();

public:
    // signals

    boost::signal< void() > emit_configured;
    boost::signal< void( const wxSize & ) > emit_canvasResized;
};

#endif
