// -*-c++-*-

/*!
  \file fedit_config.cpp
  \brief application configuration class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "fedit_config.h"

#include <rcsc/param/param_map.h>
#include <rcsc/param/cmd_line_parser.h>

#include <iostream>

const double FEditConfig::PITCH_LENGTH = 105.0;
const double FEditConfig::PITCH_WIDTH = 68.0;
const double FEditConfig::PITCH_MARGIN = 5.0;
const double FEditConfig::CENTER_CIRCLE_R = 9.15;
const double FEditConfig::PENALTY_AREA_LENGTH = 16.5;
const double FEditConfig::PENALTY_AREA_WIDTH = 40.32;
const double FEditConfig::PENALTY_CIRCLE_R = 9.15; // 7.1
const double FEditConfig::PENALTY_SPOT_DIST = 11.0;
const double FEditConfig::GOAL_AREA_LENGTH = 5.5;
const double FEditConfig::GOAL_AREA_WIDTH = 18.2;
const double FEditConfig::GOAL_DEPTH = 2.5;
const double FEditConfig::GOAL_WIDTH = 14.02;
const double FEditConfig::GOAL_POST_R = 0.06;

/*-------------------------------------------------------------------*/
/*!

*/
FEditConfig &
FEditConfig::instance()
{
    static FEditConfig s_instance;
    return s_instance;
}

/*-------------------------------------------------------------------*/
/*!

*/
FEditConfig::FEditConfig()
{
    init();
}

/*-------------------------------------------------------------------*/
/*!

*/
FEditConfig::~FEditConfig()
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
FEditConfig::init()
{
    M_maximize = false;
    M_full_screen = false;

    M_pos_x = -1;
    M_pos_y = -1;
    M_width = -1;
    M_height = -1;

    M_auto_backup = true;
    M_logging = false;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
FEditConfig::parseCmdLine( int argc,
                           char ** argv )
{
    rcsc::ParamMap system_options( "System Options" );
    rcsc::ParamMap editor_options( "Editor Options" );
    rcsc::ParamMap view_options( "View Preference Options" );

    bool help = false;
    bool version = false;
    system_options.add()
        ( "help", "h",
          rcsc::BoolSwitch( &help ),
          "print this message." )
        ( "version", "v",
          rcsc::BoolSwitch( &version ),
          "print version." )
        ;

    editor_options.add()
        ( "auto-backup", "",
          &M_auto_backup,
          "make backup files automatically" )
        ( "logging", "",
          rcsc::BoolSwitch( &M_logging ),
          "logging formation editor operation." )
        ;

    view_options.add()
        ( "maximize", "",
          rcsc::BoolSwitch( &M_maximize ),
          "start with a maximized window." )
        ( "full-screen", "",
          rcsc::BoolSwitch( &M_full_screen ),
          "start with a full screen window." )
        ( "pos-x", "",
          &M_pos_x,
          "set left x position of a main frame." )
        ( "pos-y", "",
          &M_pos_y,
          "set top y position of a main frame." )
        ( "width", "",
          &M_width,
          "set width of a main frame." )
        ( "height", "",
          &M_height,
          "set height of a main frame." )
        ;

    rcsc::CmdLineParser parser( argc, argv );

    parser.parse( system_options );
    parser.parse( editor_options );
    parser.parse( view_options );

    if ( help
         || parser.failed() )
    {
        std::cout << "Usage: " << "fedit"
                  << " [options ... ]"
                  << std::endl;
        system_options.printHelp( std::cout, false );
        editor_options.printHelp( std::cout );
        view_options.printHelp( std::cout );
        return false;
    }

    if ( version )
    {
        std::cout << "fedit" << " Version " << VERSION
                  << std::endl;
        return false;
    }

    return true;
}
