// -*-c++-*-

/*!
  \file feditor_dialog.h
  \brief Formation editor operation Dialog class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef FEDIT_QT3_FEDIT_DIALOG_H
#define FEDIT_QT3_FEDIT_DIALOG_H

#include <qdialog.h>

#include <boost/weak_ptr.hpp>

class QCloseEvent;
class QLineEdit;

class FEditData;

/*!
  \brief formation editor operation dialog
*/
class FEditDialog
    : public QDialog {

    Q_OBJECT

private:

    //! data reference
    boost::weak_ptr< FEditData > M_data_ptr;

    QLineEdit * M_method_name;

    QLineEdit * M_ball_pos_x;
    QLineEdit * M_ball_pos_y;

    QLineEdit * M_mirror_unum[11];
    QLineEdit * M_role_name[11];

    QLineEdit * M_pos_x[11];
    QLineEdit * M_pos_y[11];


public:
    explicit
    FEditDialog( QWidget * paremt );

    ~FEditDialog();

    void setData( boost::shared_ptr< FEditData > ptr )
      {
          M_data_ptr = ptr;
      }

private:
    void createWidgets();
    void setDefaultValues();

protected:
    void closeEvent( QCloseEvent * event );

private slots:
    void reverseY();
    void applyToField();

public slots:
    void updateData();

signals:
    void viewUpdated();
    void shown( bool on );

};

#endif
