// -*-c++-*-

/*!
  \file fedit_config.h
  \brief Formation Editor configuration class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef FORMATION_EDITOR_CONFIG_H
#define FORMATION_EDITOR_CONFIG_H

#include <string>

/*!
  \class FEditConfig
  \brief Formation Editor application configuration holder.
*/
class FEditConfig {
public:
    //! pitch length (X-range)
    static const double PITCH_LENGTH;
    //! pitch width (Y-range)
    static const double PITCH_WIDTH;
    //! draw margin for the outside of pitch
    static const double PITCH_MARGIN;
    //! center circle radius
    static const double CENTER_CIRCLE_R;
    //! penalty area length (X-range)
    static const double PENALTY_AREA_LENGTH;
    //! penalty area width (Y-range)
    static const double PENALTY_AREA_WIDTH;
    //! circle radius on penalty area
    static const double PENALTY_CIRCLE_R;
    //! distance from goal line to the penalty spot point
    static const double PENALTY_SPOT_DIST;
    //! goal area length (X-range)
    static const double GOAL_AREA_LENGTH;
    //! goal area width (Y-range)
    static const double GOAL_AREA_WIDTH;
    //! goal net depth (X-range)
    static const double GOAL_DEPTH;
    //! goal net depth (Y-range)
    static const double GOAL_WIDTH;
    //! goal post radius
    static const double GOAL_POST_R;

private:

    bool M_maximize;
    bool M_full_screen;

    long M_pos_x;
    long M_pos_y;
    long M_width;
    long M_height;

    bool M_auto_backup;
    bool M_logging; //!< formation editor operation logging mode

    //! private access for singleton
    FEditConfig();

    //! noncopyable
    FEditConfig( const FEditConfig & );
    //! noncopyable
    FEditConfig & operator=( const FEditConfig & );

    void init();

public:
    ~FEditConfig();

    static
    FEditConfig & instance();

    /*!
      \biref analyze command line options
    */
    bool parseCmdLine( int argc,
                       char ** argv );


    bool maximize() const
      {
          return M_maximize;
      }

    bool fullScreen() const
      {
          return M_full_screen;
      }

    int framePosX() const
      {
          return M_pos_x;
      }

    int framePosY() const
      {
          return M_pos_y;
      }

    int frameWidth() const
      {
          return M_width;
      }

    int frameHeight() const
      {
          return M_height;
      }

    bool autoBackup() const
      {
          return M_auto_backup;
      }

    bool logging() const
      {
          return M_logging;
      }

};

#endif
