// -*-c++-*-

/*!
  \file app_config.h
  \brief Application configuration class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_APP_CONFIG_H
#define SOCCERWINDOW2_APP_CONFIG_H

#include <string>

/*!
  \class AppConfig
  \brief application configuration holder.
*/
class AppConfig {
public:

    static const int MIN_SCORE_BOARD_HEIGHT;
    static const int MAX_SCORE_BOARD_HEIGHT;

    static const int DEFAULT_TIMER_INTERVAL;

private:

    std::string M_game_log_file_path;
    std::string M_game_log_dir; //!< default dir to search game log
    std::string M_debug_log_dir; //!< default dir to search debug log

    bool M_time_shift_replay;
    bool M_auto_loop_mode;
    double M_replay_speed_ratio; //!< logplayer's speed ratio. 1.0 means timer step is 100ms

    bool M_connect;
    std::string M_host;
    int M_port;
    int M_client_version;
    long M_wait_seconds;
    bool M_auto_quit_mode;
    bool M_kill_server;
    long M_server_pid;
    std::string M_server_path; //!< rcssserver command line path

    bool M_maximize;
    bool M_full_screen;

    long M_pos_x;
    long M_pos_y;
    long M_width;
    long M_height;

    //bool M_hide_menu_bar;
    bool M_hide_tool_bar;
    bool M_hide_status_bar;

    bool M_show_player_number;
    bool M_show_player_type;
    bool M_show_view_cone;
    bool M_show_stamina;
    std::string M_field_grass_type;

    double M_enlarged_ball_size;

    bool M_keepaway;

    bool M_debug_server_mode;
    long M_debug_server_port;


    // not a command line option

    // now soccerwindow2 is a monitor client mode
    bool M_monitor_client_mode;

    //! private access for singleton
    AppConfig();

    //! noncopyable
    AppConfig( const AppConfig & );
    //! noncopyable
    AppConfig & operator=( const AppConfig & );

    void init();

public:
    ~AppConfig();

    static
    AppConfig & instance();

    /*!
      \biref analyze command line options
    */
    bool parseCmdLine( int argc,
                       char ** argv );

    const
    std::string & gameLogFilePath() const
      {
          return M_game_log_file_path;
      }

    const
    std::string & gameLogDir() const
      {
          return M_game_log_dir;
      }

    void setGameLogDir( const std::string & dir )
      {
          M_game_log_dir = dir;
      }

    bool timeShiftReplay() const
      {
          return M_time_shift_replay;
      }

    bool autoLoopMode() const
      {
          return M_auto_loop_mode;
      }

    const
    double & replaySpeedRatio() const
      {
          return M_replay_speed_ratio;
      }


    int defaultTimerInterval() const;


    bool connect() const
      {
          return M_connect;
      }

    const
    std::string & host() const
      {
          return M_host;
      }

    int port() const
      {
          return M_port;
      }

    int clientVersion() const
      {
          return M_client_version;
      }

    const
    long & waitSeconds() const
      {
          return M_wait_seconds;
      }

    bool autoQuitMode() const
      {
          return M_auto_quit_mode;
      }

    bool killServer() const
      {
          return M_kill_server;
      }

    void setKillServer( bool on )
      {
          M_kill_server = on;
      }

    const
    long & serverPID() const
      {
          return M_server_pid;
      }

    void setServerPID( const long & pid )
      {
          M_server_pid = pid;
      }

    const
    std::string & serverPath() const
      {
          return M_server_path;
      }

    bool maximize() const
      {
          return M_maximize;
      }

    bool fullScreen() const
      {
          return M_full_screen;
      }

    int framePosX() const
      {
          return M_pos_x;
      }

    int framePosY() const
      {
          return M_pos_y;
      }

    int frameWidth() const
      {
          return M_width;
      }

    int frameHeight() const
      {
          return M_height;
      }

    //bool hideMenuBar() const
    //{
    //return M_hide_menu_bar;
    //}

    bool hideToolBar() const
      {
          return M_hide_tool_bar;
      }

    bool hideStatusBar() const
      {
          return M_hide_status_bar;
      }

    bool showPlayerNumber() const
      {
          return M_show_player_number;
      }

    bool showPlayerType() const
      {
          return M_show_player_type;
      }

    bool showViewCone() const
      {
          return M_show_view_cone;
      }

    bool showStamina() const
      {
          return M_show_stamina;
      }

    const
    std::string & fieldGrassType() const
      {
          return M_field_grass_type;
      }

    const
    double & enlargedBallSize() const
      {
          return M_enlarged_ball_size;
      }

    bool keepaway() const
      {
          return M_keepaway;
      }

    bool debugServerMode() const
      {
          return M_debug_server_mode;
      }
    const
    long & debugServerPort() const
      {
          return M_debug_server_port;
      }

    const
    std::string & debugLogDir() const
      {
          return M_debug_log_dir;
      }

    void setDebugLogDir( const std::string & dir )
      {
          M_debug_log_dir = dir;
      }



    bool monitorClientMode() const
      {
          return M_monitor_client_mode;
      }

    void setMonitorClientMode( bool on )
      {
          M_monitor_client_mode = on;
      }
};

#endif
