// -*-c++-*-

/*!
  \file score_board_painter.h
  \brief score board painter class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_QT_SCORE_BOARD_PAINTER_H
#define SOCCERWINDOW2_QT_SCORE_BOARD_PAINTER_H

#include "painter_interface.h"

#include <boost/shared_ptr.hpp>

class QPixmap;

class MainData;

class ScoreBoardPainter
    : public PainterInterface {
private:
    const MainData & M_main_data;
#if 1
    QRect M_time_rect;
    QRect M_left_rect;
    QRect M_right_rect;

    boost::shared_ptr< QPixmap > M_time_pixmap;
    boost::shared_ptr< QPixmap > M_left_pixmap;
    boost::shared_ptr< QPixmap > M_right_pixmap;

    int M_last_width;
    int M_last_height;
    std::string M_last_left_name;
    int M_last_left_score;
    std::string M_last_right_name;
    int M_last_right_score;
    std::string M_last_playmode;
    long M_last_cycle;
#endif
    // not used
    ScoreBoardPainter();
public:

    //! constructor with data referance
    explicit
    ScoreBoardPainter( const MainData & main_data );

    //! draw soccer field and stationary objects
    void draw( QPainter & painter );

};

#endif
